part of library;

class LibraryPage extends StatefulWidget {
  const LibraryPage({Key? key}) : super(key: key);

  @override
  State<LibraryPage> createState() => _LibraryPageState();
}

class _LibraryPageState extends State<LibraryPage> with AutomaticKeepAliveClientMixin {

  //AutomaticKeepAliveClientMixin
  @override
  Widget build(BuildContext context) {
    return GetBuilder<LibraryController>(
      init: LibraryController(),
        builder: (controller) => Scaffold(
          appBar: AppBar(
            title: const Text('图书馆'),
            actions: [
              IconButton(
                icon: const Icon(Icons.search_rounded),
                tooltip: 'Open shopping cart',
                onPressed: () {
                  context.pushNamed(Routes.search);
                },
              ),
            ],
            bottom: PreferredSize(
              preferredSize: const Size.fromHeight(38),
              child: Container(
                color: Colors.white,
                width: double.infinity,
                child: Container(
                  decoration: BoxDecoration(
                      border: Border.all(width: 0.5,color: Colours.cE5)
                  ),
                  child: Row(
                    children: [
                      Expanded(
                        child: TabBar(
                          indicator: BoxDecoration(
                              border: const Border(bottom: BorderSide(color: Colors.transparent, width: 0.0)), // 将指示器的底边框颜色设置为透明
                              color: const Color(0xFFC02D55).withOpacity(0.08)
                          ),
                          labelStyle: const TextStyle(color: AppTheme.primary,fontSize: 14,height: 1.5,fontWeight: Fonts.medium),
                          unselectedLabelColor: Colours.c9,
                          unselectedLabelStyle: const TextStyle(color: Colours.c9,fontSize: 14,height: 1.5),
                          controller: controller.tabController,
                          isScrollable: true,
                          tabs: controller.categories.map((model){
                            return Tab(text: model.name);
                          }).toList(),
                        ),
                      ),
                      GestureDetector(
                        child: Container(
                          padding: const EdgeInsets.symmetric(horizontal: 10),
                          alignment: Alignment.center,
                          // color: Colors.cyan,
                          height: 38,
                          child: Row(
                            mainAxisAlignment: MainAxisAlignment.center,
                            children: [
                              Container(
                                width: 12,
                                height: 12,
                                // color: Colors.red,
                                alignment: Alignment.center,
                                child: Image.asset(
                                  'assets/images/filter.png',
                                ),
                              ),
                              Gaps.hGaps5,
                              const Text('筛选',style: TextStyle(color: Colours.c9,fontSize: 14,height: 1.5),)
                            ],
                          ),
                          // width: 75,
                        ),
                      )
                    ],
                  ),
                ),
              ),
            ),
          ),
          body: Column(
            children: [
              Container(
                height: 43,
                color: Colours.cF9,
                child: ListView.builder(
                  scrollDirection:Axis.horizontal ,
                  itemBuilder: (BuildContext context, int index){
                    return GestureDetector(
                      child: BuildLabelWidget(model: controller.labels[index],),
                      onTap: (){
                          controller.selectLabel( controller.labels[index]);
                      },
                    );
                  },
                  itemCount: controller.labels.length,
                ),
              ),
              Container(
                color: Colors.transparent,
                padding: const EdgeInsets.symmetric(horizontal: 10),
                child: BuildBanner(items: controller.ads,),
              ),
              Expanded(
                child: TabBarView(
                  controller: controller.tabController,
                  children: List.generate(controller.categories.length, (index){
                    print('=======================================$index');
                    return LibraryContentPage(controller: controller,);
                  })
                ),
              ),
            ],
          ),
        ),
    );
  }


  @override
  bool get wantKeepAlive => true;
}
