part of apis;

abstract class MineAPI {

  /// 1、个人信息以及8个数据
  ///
  static Future <UserInfoModel> userInfo() async {
    final result = await HttpService.to.post(
      '/v1/members/Information/getMyStatistics',
      params: {},
    );
    if (result.data is! Map ) return UserInfoModel();
    return UserInfoModel.fromJson(result.data);
  }

  /// 2、我的收藏
  static Future <List<CourseModel>> love({
    int page = 1,
    int limit = 10,
  }) async {
    final result = await HttpService.to.post(
      '/v1/members/Information/myCollection',
      params: {
        'page': page,
        'page_size': limit,
      },
    );
    if (result.data is! Map && result.data['list'] is! List) return [];
    return List.generate(result.data['list'].length, (index){
      return CourseModel.fromJson(result.data['list'][index]);
    });
  }

  /// 3、笔记
  ///
  static Future <List<CourseModel>> note({
    int page = 1,
    int limit = 10,
  }) async {
    final result = await HttpService.to.post(
      '/v1/members/Information/myNotes',
      params: {
        'page': page,
        'page_size': limit,
      },
    );
    if (result.data is! Map && result.data['list'] is! List) return [];
    return List.generate(result.data['list'].length, (index){
      return CourseModel.fromJson(result.data['list'][index]);
    });
  }

  /// 4、错题
  ///
  static Future <List<CourseModel>> wrong({
    int page = 1,
    int limit = 10,
  }) async {
    final result = await HttpService.to.post(
      '/v1/members/Information/myWrongQuestion',
      params: {
        'page': page,
        'page_size': limit,
      },
    );
    if (result.data is! Map && result.data['list'] is! List) return [];
    return List.generate(result.data['list'].length, (index){
      return CourseModel.fromJson(result.data['list'][index]);
    });
  }

  /// 5、紫金币记录
  ///
  static Future <List<RecordModel>> coin({
    int page = 1,
    int limit = 10,
  }) async {
    final result = await HttpService.to.post(
      '/v1/members/Information/getBeanList',
      params: {
        'page': page,
        'page_size': limit,
      },
    );
    if (result.data is! Map && result.data['list'] is! List) return [];
    return List.generate(result.data['list'].length, (index){
      return RecordModel.fromJson(result.data['list'][index]);
    });
  }

  /// 6、积分记录
  ///
  static Future <List<RecordModel>> point({
    int page = 1,
    int limit = 10,
  }) async {
    final result = await HttpService.to.post(
      '/v1/members/Information/getIntegralList',
      params: {
        'page': page,
        'page_size': limit,
      },
    );
    if (result.data is! Map && result.data['list'] is! List) return [];
    return List.generate(result.data['list'].length, (index){
      return RecordModel.fromJson(result.data['list'][index]);
    });
  }

  /// 7、讨论
  ///
  static Future <List<CourseModel>> discuss({
    int page = 1,
    int limit = 10,
  }) async {
    final result = await HttpService.to.post(
      '/v1/members/Information/myComment',
      params: {
        'page': page,
        'page_size': limit,
      },
    );
    if (result.data is! Map && result.data['list'] is! List) return [];
    return List.generate(result.data['list'].length, (index){
      return CourseModel.fromJson(result.data['list'][index]);
    });
  }

  /// 8、优惠券列表
  ///
  static Future <List<CouponModel>> coupon({
    int page = 1,
    int limit = 10,
    required int type,
  }) async {
    final result = await HttpService.to.post(
      '/v1/coupon/Coupon/getCouponRecordListSAll',
      params: {
        'page': page,
        'page_size': limit,
        'type': type
      },
    );
    if (result.data is! Map && result.data['list'] is! List) return [];
    return List.generate(result.data['list'].length, (index){
      return CouponModel.fromJson(result.data['list'][index]);
    });
  }


  /// 9、获取最新版本
  ///
  static Future <UpdateModel> update() async {
    final result = await HttpService.to.post(
      '/v1/members/Information/getVersion',
      params: {},
    );
    if (result.data is! Map) return UpdateModel();
    return UpdateModel.fromJson(result.data);
  }

  /// 10、版本介绍
  static Future <List<VersionModel>> versions({
    int page = 1,
    int limit = 10,
  }) async {
    final result = await HttpService.to.post(
      '/v1/members/Information/getAllVersionList',
      params: {
        'page': page,
        'page_size': limit,
      },
    );
    if (result.data is! Map && result.data['list'] is! List) return [];
    return List.generate(result.data['list'].length, (index){
      return VersionModel.fromJson(result.data['list'][index]);
    });
  }

  /// 11、修改用户信息
  ///
  static Future <bool> changeInfo({
    String? name,
    num? sex,
    String? headImg
  }) async {
    Map<String,dynamic> params = {};
    if (name != null){
      params['name'] = name;
    }
    if (sex != null){
      params['sex'] = sex;
    }
    if (headImg != null){
      params['head_img'] = headImg;
    }
    final result = await HttpService.to.post(
      '/v1/members/Information/editInformation',
      params: params
    );
    if (result.data is Map && result.data['is_success'] == 1){
      return true;
    }
    return false;
  }


}