part of book_pay;

class BuildPayCount extends StatelessWidget {
  final void Function()? payTap;
  final void Function()? showTap;
  final BookPayController controller;
  const BuildPayCount({
    Key? key,
    required this.payTap,
    required this.showTap,
    required this.controller
  }) : super(key: key);


  @override
  Widget build(BuildContext context) {
    return GetBuilder<BookPayController>(
      init: BookPayController(buy: []),
      builder:(controller)=> Container(
        padding: EdgeInsets.symmetric(horizontal: 15.w),
        height: 55.w,
        color: Colors.white,
        child: Row(
          mainAxisAlignment: MainAxisAlignment.spaceBetween,
          crossAxisAlignment: CrossAxisAlignment.center,
          children: [
            IgnorePointer(
              ignoring: controller.showModel.integralSwitch =='0'&& controller.showModel.couponSwitch ==''?true:false,
              child: GestureDetector(
                onTap: showTap,
                child: Row(
                  crossAxisAlignment: CrossAxisAlignment.center,
                  children: [
                    Text('应付：',style: TextStyle(fontSize:14.w,color: Colours.c3 ,height: 1.1),),
                    Text('￥${controller.finalPrice}',style: TextStyle(fontSize:15.w,color:AppTheme.primary,fontWeight: Fonts.medium ,height: 1.1),),
                    controller.showModel.integralSwitch =='1'&& controller.showModel.couponSwitch =='1'?SizedBox(
                      // color: Colors.cyan,
                      width: 20.w,
                      height: 20.w,
                      child: Image.asset('assets/images/pay_up.png')
                    ):const SizedBox()
                  ],
                ),
              ),
            ),
            GestureDetector(
              onTap: payTap,
              child: Container(
                decoration: BoxDecoration(
                    borderRadius: BorderRadius.circular(15.w),
                    color: AppTheme.primary
                ),
                padding:  EdgeInsets.symmetric(horizontal:13.5.w,vertical: 8.w),
                child:  Text('确认支付',style: TextStyle(fontSize: 14.w,fontWeight: Fonts.medium,color: Colors.white),),
              ),
            )
          ],
        ),
      ),
    );
  }
}
