part of library;

class LibraryContentPage extends StatefulWidget {
  final LibraryController controller;
  // final CategoryModel categoryModel;
  const LibraryContentPage({
    Key? key,
    required this.controller,
    // required this.categoryModel
  }) : super(key: key);

  @override
  State<LibraryContentPage> createState() => _LibraryContentPageState();
}

class _LibraryContentPageState extends State<LibraryContentPage> with AutomaticKeepAliveClientMixin {
  @override
  Widget build(BuildContext context) {
    return ListView.builder(
      shrinkWrap: true,
      physics: const NeverScrollableScrollPhysics(),
      itemCount: widget.controller.books.length,
      itemBuilder: (BuildContext context, int index) {
        CourseModel model = widget.controller.books[index];
        return GestureDetector(
          onTap: (){
            context.pushNamed(Routes.bookDetail,queryParameters: {'book_id':model.bookId.toString()});
          },
          child: LibraryCell(model: model,onTap: (){
            widget.controller.love(bookId: model.bookId.toString(), isCollection: model.isCollection!);
          },),
        );
      }
    );
  }
  @override
  bool get wantKeepAlive => true;
}
