part of recharge;



class CoinRechargePage extends StatefulWidget {
  const CoinRechargePage({Key? key}) : super(key: key);

  @override
  State<CoinRechargePage> createState() => _CoinRechargePageState();
}

class _CoinRechargePageState extends State<CoinRechargePage> {
  @override
  Widget build(BuildContext context) {
    return GetBuilder<CoinRechargeController>(
      init: CoinRechargeController(),
      builder:(controller) => Container(
        // height: 100,
        // color: Colors.amberAccent,
        child: Column(
          mainAxisSize: MainAxisSize.min,
          children: [
            Container(
              padding: EdgeInsets.symmetric(vertical: 17),
              width: double.infinity,
              margin: EdgeInsets.fromLTRB(10, 10, 10, 0),
              child: Container(
                color: Colors.red,
                child:Stack(
                  children: [
                    Row(
                      mainAxisAlignment: MainAxisAlignment.center,
                      children: [
                        Text('紫荆币充值',textAlign:TextAlign.center),
                      ],
                    ),
                    Positioned(
                      right: 0,
                      top: 0,
                      child: Container(
                        width: 20,
                        height: 20,
                        color: Colors.green,
                      ),
                    )
                  ],
                )
              ),
            ),
            Container(
              margin: EdgeInsets.symmetric(horizontal: 20),
                child: _buildAudioGridView()
            ),
            Gaps.vGaps15,
            _buildListView(controller),
            Gaps.vGaps15,
            Container(
              margin: EdgeInsets.symmetric(horizontal:15),
              child: CustomGradientButton(
                text: '立即充值',
                isEnabled: true,
                onPressed: () {
                  // context.goNamed(Routes.login);
                },
              ),
            ),
            Gaps.vGaps15,
            RichText(text: TextSpan(
              children: [
                TextSpan(text: '充值即代表同意',style: TextStyle(fontSize: 13.w,height: 1.5,color: Colours.c9)),
                TextSpan(text: '《用户充值协议》',style: TextStyle(fontSize: 13.w,height: 1.5,color: Color(0xFF2A82D9))),
              ]
            )),
            Gaps.vGaps15
          ],
        ),
      ),
    );
  }

  Widget _buildAudioGridView(){
    return GridView.builder(
      // padding: const EdgeInsets.only(left: 13,top: 10),
      physics: NeverScrollableScrollPhysics(),
      shrinkWrap: true,
      gridDelegate: SliverGridDelegateWithFixedCrossAxisCount(
          crossAxisCount: 3,
          crossAxisSpacing: 10.w,
          mainAxisSpacing: 10.w,
          childAspectRatio: 2
      ),
      itemBuilder: (BuildContext context, int index) {
        return Container(
          decoration: BoxDecoration(
              color: Colors.red,
            borderRadius: BorderRadius.circular(8.w),
            border: Border.all(width: 0.5.w,color: Color(0xFFDADADA))
          ),

          child: Column(
            mainAxisAlignment: MainAxisAlignment.center,
            children: [
              Text('42紫荆币',style: TextStyle(color: Colours.c3,fontSize: 14,height: 1.5),),
              Text('6元',style: TextStyle(color: Colours.c9,fontSize: 11,height: 1.5),),
            ],
          ),
        );
      },
      itemCount: 6,
    );
  }
  Widget _buildListView(CoinRechargeController controller){
    return ListView.builder(
      physics: const NeverScrollableScrollPhysics(),
      padding: EdgeInsets.symmetric(horizontal: 20.w),
      shrinkWrap:true,
      itemBuilder: (BuildContext context, int index){
        PayModel model = controller.pays[index];
        return GestureDetector(
            onTap: (){
              controller.setPayModel(model);
            },
            child: BuildPayWay(model:model,));
      },
      itemCount: controller.pays.length,
    );
  }
}
