part of help_center;

class BuildItem extends StatelessWidget {
  final HelpCenterModel model;

  const BuildItem({Key? key, required this.model}) : super(key: key);

  @override
  Widget build(BuildContext context) {
    return Container(
      color: Colors.white,
      padding: EdgeInsets.only(top: 10.w, right: 15.w, left: 15.w),
      child: Column(
        children: [
          Row(
            mainAxisAlignment: MainAxisAlignment.spaceBetween,
            children: [
              Row(
                children: <Widget>[
                  Text(
                    '${model!.id}.',
                    style: TextStyle(
                        fontSize: 14.w, height: 1.5.w, color: Colours.c3),
                  ),
                  Padding(
                    padding: const EdgeInsets.only(left: 10), // 设置左部间隔
                    child: Text(
                      model.helpTitle ?? '',
                      style: TextStyle(
                          fontSize: 12.w, height: 1.5.w, color: Colours.c9),
                    ),
                  ),
                ],
              ),
              Image.asset('assets/images/right_arrow.png')
            ],
          ),
          Gaps.vGaps10,
          Container(
            height: 0.5.w,
            color: Colours.cF0,
          )
        ],
      ),
    );
  }
}
