part of web;

class ReadNotePage extends StatefulWidget {
  final BookDetailModel bookDetailModel;
  // 点击 搜索全文 中的列表事件
  final void Function()? onTapSearchItem;
  // 当前的章节id
  final String chapterId;
  final void Function()? onTap;
  const ReadNotePage({
    Key? key,
    required this.onTap,
    required this.bookDetailModel,
    required this.chapterId,
    this.onTapSearchItem
  }) : super(key: key);

  @override
  State<ReadNotePage> createState() => _ReadNotePageState();
}

class _ReadNotePageState extends State<ReadNotePage> {
  late TextEditingController searchController = TextEditingController();
  @override
  Widget build(BuildContext context) {
    return GetBuilder<NoteController>(
      init: NoteController(bookDetailModel: widget.bookDetailModel,chapterId: widget.chapterId),
      builder:(controller) =>Column(
        crossAxisAlignment: CrossAxisAlignment.end,
        children: [
          GestureDetector(
            onTap: (){
              widget.onTap!();
            },
            child: Container(
                // color: Colors.red,
                padding: EdgeInsets.only(left: 15.w,right: 15.w,top: 15.w,bottom: 15.w),
                child: Image.asset('assets/images/close.png')
            ),
          ),
          Row(
            children: [
              Expanded(
                child: Container(
                  margin: EdgeInsets.only(left: 15.w,right: 15.w,),
                  decoration: BoxDecoration(
                    color: const Color(0xFFF9F9F9),
                    borderRadius: BorderRadius.circular(17.5.w),
                    boxShadow: [
                      BoxShadow(
                        color: const Color(0xFFC7C7C7).withOpacity(0.5),
                        offset: Offset(3.w, 0),
                        blurRadius: 10.w,
                        spreadRadius: 0.w,
                      ),
                    ],
                  ),
                  child: ClipRRect(
                    borderRadius: BorderRadius.circular(17.5.w),
                    child: CustomInputSearch(
                      controller: controller.searchInput,
                      readOnly: false,
                      hintText: '搜索全文---笔记',
                      onTap: () {
                        // context.pushNamed(Routes.msgs);
                      },
                      onEditingComplete: () {
                        controller.setShowSearch(true);
                        controller.onRefreshSearch();
                        Tools.unfocus();
                      },
                    ),
                  ),
                ),
              ),
              controller.showSearch?GestureDetector(
                  onTap: () {
                    controller.setShowSearch(false);
                    Tools.unfocus();
                  },
                  child:  Container(
                    margin: EdgeInsets.only(right: 15.w),
                    child: Text('取消'),
                  )
              ):const SizedBox(),
            ],
          ),
          controller.showSearch? Expanded(child: BuildSearchAll(
            onTap: (){
              if (widget.onTapSearchItem !=null) {
                widget.onTapSearchItem!();
              }
            },
            searchALlResults: controller.searchALlResults
          )):
          controller.showSearch?const SizedBox():BuildBook(bookDetailModel: widget.bookDetailModel,),
          controller.showSearch?const SizedBox():Expanded(
            child: MediaQuery.removePadding(
              context: context,
              removeTop: true,
              child: ListView.builder(
                itemBuilder: (BuildContext context,int index){
                  NoteModel model = controller.notes[index];
                  // 划线
                  if(model.types == 1){
                    return  BuildLine(model: model,);
                  }
                  // 高亮
                  else if(model.types == 2){
                    return BuildHigh(model: model,);
                  }
                  // 笔记
                  else if(model.types == 3){
                    return BuildNote(model: model,);
                  }
                },
                itemCount: controller.notes.length,
              ),
            ),
          ),
        ],
      ),
    );
  }
}
