part of utils;


abstract class Tools {
  static void unfocus() {
    WidgetsBinding.instance.focusManager.primaryFocus?.unfocus();
  }

  static String dateFromMS(
      int timestamp, {
        String pattern = 'yyyy-MM-dd',
        bool humanize = false,
      }) {
    final dateTime = DateTime.fromMillisecondsSinceEpoch(timestamp*1000);
    if (humanize) {
      final now = DateTime.now();
      final difference = now.difference(dateTime);
      if (difference.inMinutes < 60) {
        if (difference.inMinutes < 1) return '刚刚';
        return '${difference.inMinutes}分钟前';
      } else if (difference.inHours < 24) {
        return '${difference.inHours}小时前';
      } else if (difference.inDays < 30) {
        return '${difference.inDays}天前';
      } else if (now.year == dateTime.year) {
        return DateFormat('MM-dd').format(dateTime);
      }
    }
    return DateFormat(pattern).format(dateTime);
  }

  static String formatDuration(Duration duration) {
    String twoDigits(int n) => n.toString().padLeft(2, '0');
    String twoDigitMinutes = twoDigits(duration.inMinutes.remainder(60));
    String twoDigitSeconds = twoDigits(duration.inSeconds.remainder(60));
    return "${duration.inHours}:$twoDigitMinutes:$twoDigitSeconds";
  }

  static Future<String> getDirectory() async {
    // getTemporaryDirectory
    final directory = await getApplicationSupportDirectory();
    return directory!.path;
  }

  // 语音文件名称
  static String generateVoiceFileName(){
    DateTime now = DateTime.now();
    String formattedDate = DateFormat('yyyyMMddHHmmss').format(now);
    return 'voice_$formattedDate.mp4';
  }

  // 判断当前网络状态
  static Future<bool> checkCurrentNetStatus() async {
    final connectivityResult = await (Connectivity().checkConnectivity());
    if (connectivityResult == ConnectivityResult.none){
      return false;
    }
    return true;
    // if (connectivityResult == ConnectivityResult.mobile) {
    //   // I am connected to a mobile network.
    // } else if (connectivityResult == ConnectivityResult.wifi) {
    //   // I am connected to a wifi network.
    // } else if (connectivityResult == ConnectivityResult.ethernet) {
    //   // I am connected to a ethernet network.
    // } else if (connectivityResult == ConnectivityResult.vpn) {
    //   // I am connected to a vpn network.
    //   // Note for iOS and macOS:
    //   // There is no separate network interface type for [vpn].
    //   // It returns [other] on any device (also simulator)
    // } else if (connectivityResult == ConnectivityResult.bluetooth) {
    //   // I am connected to a bluetooth.
    // } else if (connectivityResult == ConnectivityResult.other) {
    //   // I am connected to a network which is not in the above mentioned networks.
    // } else if (connectivityResult == ConnectivityResult.none) {
    //   // I am not connected to any network.
    // }
  }

  // static void readChapter({required int type}) async {
  //   Console.log('---------------获取所有html---------------------------------');
  //   String docPath = await getDirectory();
  //   String filePath = '$docPath/$1';
  //   Directory directory = Directory(filePath);
  //   // 获取目录下的所有文件
  //   List<FileSystemEntity> files = directory.listSync(recursive: true);
  //
  //   // 打印所有 HTML 文件路径
  //   for (var file in files) {
  //     if (file is File && file.path.toLowerCase().endsWith('.html')) {
  //       Console.log('HTML File: ${file.path}');
  //     }
  //   }
  //   Console.log('---------------获取所有html---------------------------------');
  //   // 先找到对应文件
  //   if(type == 0){
  //
  //   }
  // }
}




