part of library;


class BuildLabelWidget extends StatelessWidget {
  final LabelModel model;
  const BuildLabelWidget({
    Key? key,
    required this.model
  }) : super(key: key);

  @override
  Widget build(BuildContext context) {
    return Container(
      margin: const EdgeInsets.only(left: 10),
      color: Colors.transparent,
      width: 65,
      padding: const EdgeInsets.only(top: 10,bottom: 10),
      child: Container(
        // padding: EdgeInsets.all(8),
          alignment: Alignment.center,
          padding: const EdgeInsets.only(left: 8,right:8 ),
          height: 23,
          decoration: BoxDecoration(
            borderRadius: const BorderRadius.all(Radius.circular(12.5)),
            border:model.selected? Border.all(color:AppTheme.primary,width: 0.5,style: BorderStyle.solid):null,
            color: Colors.white,
            boxShadow: model.selected?[
              BoxShadow(
                color: AppTheme.primary.withOpacity(0.3),
                offset: const Offset(0, 1),
                blurRadius: 2.w,
                spreadRadius: 0.w,
              ),
            ]:null,
          ),
          child: Text(model.name??'',style: TextStyle(fontSize: 13,height: 1.5,color: model.selected?AppTheme.primary:Colours.c9,fontWeight: Fonts.medium),)
      ),
    );
  }
}


