part of apis;

abstract class AccountAPI {

  /// 登录
  static Future <UserModel> login({
    required String phone,
    required String type,
    String? password,
    String? code,
  }) async {
    assert((password != null && code == null) ||
        (password == null && code != null),
    'Provide either a password or a verification code, not both.');

    Map<String,dynamic> params = {
      'phone' : phone,
      'type' : type,
    };

    // 密码登录
    if(type == '1'){
      params['password'] = password;
    }
    // 验证码登录
    if(type == '2'){
      params['password'] = password;
    }
    final result = await HttpService.to.post(
      '/v1/members/login/login',
      excludeToken: true,
      showLoading: true,
      params: params
    );
    print(result.data);
    if (result.data is! Map) return UserModel();
    return UserModel.fromJson(result.data);
  }

  /// 发送验证码
  static Future sendCode({
    required String phone,
    required String type,
  }) async {
    final result = await HttpService.to.post(
      '/v1/members/login/sendCode',
      excludeToken: true,
      showLoading: true,
    );
  }



}