part of study_history;

class StudyHistoryPage extends StatefulWidget {
  const StudyHistoryPage({Key? key}) : super(key: key);

  @override
  State<StudyHistoryPage> createState() => _StudyHistoryPageState();
}

class _StudyHistoryPageState extends State<StudyHistoryPage> {
  @override
  Widget build(BuildContext context) {
    return GetBuilder<HistoryController>(
      init: HistoryController(),
      builder:(controller) => Scaffold(
        appBar: AppBar(
          centerTitle: true,
          title: const Text('最近学习'),
        ),
        body: CustomPullScrollView(
          controller: controller.refreshController,
          onRefresh: controller.onRefresh,
          onLoading: controller.onLoading,
          child:controller.histories.isEmpty?Container(
            padding: EdgeInsets.only(top: 110.w),
            alignment: Alignment.center,
            child: Column(
              crossAxisAlignment: CrossAxisAlignment.center,
              children: [
                SizedBox(height: 152.w, width: 195.w,
                  child: Image.asset( 'assets/images/none.png',),),
                SizedBox(height: 13.w,),
              ],
            ),
          ): ListView.builder(
            itemBuilder: (BuildContext context, int index) {
              return BuildDayItem(
                historyModel: controller.histories[index],
                onTap: (CourseModel courseModel){
                  context.pushNamed(Routes.bookDetail,queryParameters: {'book_id':courseModel.bookId.toString()});
                },
              );
            },
            itemCount: controller.histories.length,
          ),
        ),
      ),
    );
  }
}
