part of utils;

abstract class AssetsPicker {
  static final ImagePicker _imagePicker = ImagePicker();

  /// 获取图库
  static Future<XFile?> image({
    required BuildContext context,
    ImageSource source = ImageSource.gallery,
    double maxWidth = 1024,
    double maxHeight = 1024,
  }) async {
    if (!(await Access.photos())) {
      if (context.mounted) {
        // CustomDialog.showAccess(
        //   context: context,
        //   content: const Text('获取相册权限'),
        // );
        _showSettingDialog(context,'获取相册权限');
      }
      return null;
    }
    return _imagePicker.pickImage(
      source: source,
      // maxWidth: maxWidth,
      // maxHeight: maxHeight,
      // imageQuality: 100
    );
  }
  /// 拍照
  static Future<XFile?> camera({
    required BuildContext context,
    ImageSource source = ImageSource.camera,
    double maxWidth = 512,
    double maxHeight = 512,
  }) async {
    if (!(await Access.photos())) {
      if (context.mounted) {
        // CustomDialog.showAccess(
        //   context: context,
        //   content: const Text('获取拍照权限'),
        // );
        _showSettingDialog(context,'获取拍照权限');
      }
      return null;
    }
    return _imagePicker.pickImage(
      source: source,
      // maxWidth: maxWidth,
      // maxHeight: maxHeight,
    );
  }

  static _showSettingDialog(BuildContext context,String content) {
    showDialog(
      context: context,
      builder: (BuildContext context) {
        return WillPopScope(
          onWillPop: () => Future.value(true),
          child: AlertDialog(
            insetPadding: EdgeInsets.zero, // 设置水平边距
            shape: RoundedRectangleBorder(
              borderRadius: BorderRadius.circular(8.0.w),
            ),
            // 去除操作按钮区域的内边距
            actionsPadding: EdgeInsets.zero,
            title: Container(
              alignment: Alignment.center,
              child: Text('权限申请', style: TextStyle(
                  fontSize: 20.w,
                  color: Colours.c3,
                  fontWeight: Fonts.boldSemi),),
            ),
            actions: <Widget>[
              Row(
                mainAxisAlignment: MainAxisAlignment.center,
                children: [
                  Column(
                    mainAxisAlignment: MainAxisAlignment.start,
                    children: [
                      Padding(
                        padding: EdgeInsets.only(top: 5.5.w),
                        child: Text(
                          content,
                          style: TextStyle(
                              fontSize: 15.w,
                              color: Colours.c9,
                              fontWeight: Fonts.medium),
                        ),
                      ),
                      SizedBox(
                        height: 22.w,
                      ),
                      Container(
                        height: 1, // 设置分割线的高度
                        width: 216.5.w, // 设置分割线的宽度
                        color: Colours.cLine, // 设置分割线的颜色
                      ),
                      Row(
                        mainAxisAlignment: MainAxisAlignment.spaceBetween,
                        children: [
                            Padding(padding: EdgeInsets.only(right: 28.w),
                              child:  GestureDetector(
                                child:
                                Container(
                                  width: 85.w,
                                  color: Colours.cFF,
                                  alignment: Alignment.center,
                                  child:  const Text(
                                    '取消',
                                    style: TextStyle(
                                        color: Colours.c6,
                                        fontSize: 15,
                                        fontWeight: Fonts.medium),
                                  ),
                                ),
                                onTap: () => Navigator.of(context).pop(),
                              ),),
                          Container(
                            height: 39.5.w, // 设置分割线的高度
                            width: 1, // 设置分割线的宽度
                            color: Colours.cLine, // 设置分割线的颜色
                          ),
                          Padding(padding: EdgeInsets.only(left: 28.w),
                            child:   GestureDetector(
                              child: Container(
                                width: 85.w,
                                color: Colours.cFF,
                                alignment: Alignment.center,
                                child:  const Text(
                                  '设置',
                                  style: TextStyle(
                                      color: Colours.cAB1941,
                                      fontSize: 15,
                                      fontWeight: Fonts.boldSemi),
                                ),
                              ),
                              onTap: () {
                                Access.setting();
                              },
                            ),
                          ),

                        ],
                      ),
                    ],
                  ),
                ],
              ),
            ],
          ),
        );
      },
    );
  }
}
