part of answer;


class AnswerPage extends StatefulWidget {
  final Map<String,String> params;
  const AnswerPage({
    Key? key,
    required this.params
  }) : super(key: key);

  @override
  State<AnswerPage> createState() => _AnswerPageState();
}

class _AnswerPageState extends State<AnswerPage> {
  @override
  Widget build(BuildContext context) {
    return Scaffold(
        appBar: AppBar(
          title: const Text('知识测评'),
        ),
        body: InAppWebView(
          initialUrlRequest: URLRequest(
            url: Uri.parse(widget.params['url']??''),
          ),
          onLoadStop: (controller, url) {
            String str = '$kServerUrl,${widget.params['book_id']},${widget.params['chapter_id']},${widget.params['token']},${widget.params['position']}';
            Console.log('知识测评--------传给前端的参数--------------------------------$str');
            controller.evaluateJavascript(source: 'callbackInFlutterComponent("$str");');

            controller.addJavaScriptHandler(handlerName: 'evaluatingSubmitCallback', callback: (args){
              Console.log('监听笔记回调------------------------------------------------$args');
              context.pop();
              // readController.titleInput.text = args.toString();
            });
          },
          onConsoleMessage: (controller, consoleMessage) {
            // 接收从 WebView 发送的消息
            Console.log("知识测评-------Received message from WebView-----------------------------: ${consoleMessage.message}");
          },
        )
    );
  }
}
