part of models;

class ReadModel {
  ReadModel({required this.value, required this.name, this.link, this.icon});

  String value;
  String name;
  String? link;
  String? icon;
}

/// 紫金币 积分  模型
///
class RecordModel {
  RecordModel({
    this.integralId,
    this.options,
    this.numbers,
    this.result,
    this.remarks,
    this.createTime,
  });

  RecordModel.fromJson(dynamic json) {
    integralId = json['integral_id'];
    options = json['options'];
    numbers = json['numbers'];
    result = json['result'];
    remarks = json['remarks'];
    createTime = json['create_time'];
  }

  num? integralId;
  num? options;
  num? numbers;
  num? result;
  String? remarks;
  String? createTime;

  RecordModel copyWith({
    num? integralId,
    num? options,
    num? numbers,
    num? result,
    String? remarks,
    String? createTime,
  }) =>
      RecordModel(
        integralId: integralId ?? this.integralId,
        options: options ?? this.options,
        numbers: numbers ?? this.numbers,
        result: result ?? this.result,
        remarks: remarks ?? this.remarks,
        createTime: createTime ?? this.createTime,
      );

  Map<String, dynamic> toJson() {
    final map = <String, dynamic>{};
    map['integral_id'] = integralId;
    map['options'] = options;
    map['numbers'] = numbers;
    map['result'] = result;
    map['remarks'] = remarks;
    map['create_time'] = createTime;
    return map;
  }
}

/// 优惠券模型
///
class CouponModel {
  CouponModel({
    this.couponRecId,
    this.endTime,
    this.startTime,
    this.couponId,
    this.useStatus,
    this.couponName,
    this.normPrice,
    this.reducedPrice,
    this.type
  });

  CouponModel.fromJson(dynamic json) {
    couponRecId = json['coupon_rec_id'];
    endTime = json['end_time'];
    startTime = json['start_time'];
    couponId = json['coupon_id'];
    useStatus = json['use_status'];
    couponName = json['coupon_name'];
    normPrice = json['norm_price'];
    reducedPrice = json['reduced_price'];
    type = json['use_status'];
  }

  num? couponRecId;
  String? endTime;
  String? startTime;
  num? couponId;
  num? useStatus;
  String? couponName;
  num? normPrice;
  String? reducedPrice;
  num? type;

  CouponModel copyWith({
    num? couponRecId,
    String? endTime,
    String? startTime,
    num? couponId,
    num? useStatus,
    String? couponName,
    num? normPrice,
    String? reducedPrice,
    num? type,
  }) =>
      CouponModel(
        couponRecId: couponRecId ?? this.couponRecId,
        endTime: endTime ?? this.endTime,
        startTime: startTime ?? this.startTime,
        couponId: couponId ?? this.couponId,
        useStatus: useStatus ?? this.useStatus,
        couponName: couponName ?? this.couponName,
        normPrice: normPrice ?? this.normPrice,
        reducedPrice: reducedPrice ?? this.reducedPrice,
        type: type ?? this.type
      );

  Map<String, dynamic> toJson() {
    final map = <String, dynamic>{};
    map['coupon_rec_id'] = couponRecId;
    map['end_time'] = endTime;
    map['start_time'] = startTime;
    map['coupon_id'] = couponId;
    map['use_status'] = useStatus;
    map['coupon_name'] = couponName;
    map['norm_price'] = normPrice;
    map['reduced_price'] = reducedPrice;
    map['use_status'] = type;
    return map;
  }
}

/// 更新模型
class UModel {
  UModel({
    this.version,
    this.url,
    this.remarks,
  });

  UModel.fromJson(dynamic json) {
    version = json['version'];
    url = json['url'];
    remarks = json['remarks'];
  }

  String? version;
  String? url;
  String? remarks;

  UModel copyWith({
    String? version,
    String? url,
    String? remarks,
  }) =>
      UModel(
        version: version ?? this.version,
        url: url ?? this.url,
        remarks: remarks ?? this.remarks,
      );

  Map<String, dynamic> toJson() {
    final map = <String, dynamic>{};
    map['version'] = version;
    map['url'] = url;
    map['remarks'] = remarks;
    return map;
  }
}

/// 版本介绍模型
class VersionModel {
  VersionModel({
    this.id,
    this.version,
    this.remarks,
    this.url,
    this.createTime,
    this.updateTime,
  });

  VersionModel.fromJson(dynamic json) {
    id = json['id'];
    version = json['version'];
    remarks = json['remarks'];
    url = json['url'];
    createTime = json['create_time'];
    updateTime = json['update_time'];
  }

  num? id;
  String? version;
  String? remarks;
  String? url;
  String? createTime;
  String? updateTime;

  VersionModel copyWith({
    num? id,
    String? version,
    String? remarks,
    String? url,
    String? createTime,
    String? updateTime,
  }) =>
      VersionModel(
        id: id ?? this.id,
        version: version ?? this.version,
        remarks: remarks ?? this.remarks,
        url: url ?? this.url,
        createTime: createTime ?? this.createTime,
        updateTime: updateTime ?? this.updateTime,
      );

  Map<String, dynamic> toJson() {
    final map = <String, dynamic>{};
    map['id'] = id;
    map['version'] = version;
    map['remarks'] = remarks;
    map['url'] = url;
    map['create_time'] = createTime;
    map['update_time'] = updateTime;
    return map;
  }
}

/// 用户信息模型
class UserInfoModel {
  UserInfoModel({
    this.name,
    this.headImg,
    this.sex,
    this.phone,
    this.couponNums,
    this.commentNums,
    this.ordersNums,
    this.noteNums,
    this.wrongNums,
    this.collectNums,
    this.integralNums,
    this.password,
    this.gradeId,
    this.gradeName,
    this.beanNums,
  });

  UserInfoModel.fromJson(dynamic json) {
    name = json['name'];
    headImg = json['head_img'];
    sex = json['sex'];
    phone = json['phone'];
    couponNums = json['coupon_nums'];
    commentNums = json['comment_nums'];
    ordersNums = json['orders_nums'];
    noteNums = json['note_nums'];
    wrongNums = json['wrong_nums'];
    collectNums = json['collect_nums'];
    integralNums = json['integral_nums'];
    password = json['password'];
    gradeId = json['grade_id'];
    gradeName = json['grade_name'];
    beanNums = json['bean_nums'];
  }

  String? name;
  String? headImg;
  num? sex;
  String? phone;
  num? couponNums;
  num? commentNums;
  num? ordersNums;
  num? noteNums;
  num? wrongNums;
  num? collectNums;
  num? integralNums;
  String? password;
  num? gradeId;
  String? gradeName;
  String? beanNums;

  UserInfoModel copyWith({
    String? name,
    String? headImg,
    num? sex,
    String? phone,
    num? couponNums,
    num? commentNums,
    num? ordersNums,
    num? noteNums,
    num? wrongNums,
    num? collectNums,
    num? integralNums,
    String? password,
    num? gradeId,
    String? gradeName,
    String? beanNums,
  }) =>
      UserInfoModel(
        name: name ?? this.name,
        headImg: headImg ?? this.headImg,
        sex: sex ?? this.sex,
        phone: phone ?? this.phone,
        couponNums: couponNums ?? this.couponNums,
        commentNums: commentNums ?? this.commentNums,
        ordersNums: ordersNums ?? this.ordersNums,
        noteNums: noteNums ?? this.noteNums,
        wrongNums: wrongNums ?? this.wrongNums,
        collectNums: collectNums ?? this.collectNums,
        integralNums: integralNums ?? this.integralNums,
        password: password ?? this.password,
        gradeId: gradeId ?? this.gradeId,
        gradeName: gradeName ?? this.gradeName,
        beanNums: beanNums ?? this.beanNums,
      );

  Map<String, dynamic> toJson() {
    final map = <String, dynamic>{};
    map['name'] = name;
    map['head_img'] = headImg;
    map['sex'] = sex;
    map['phone'] = phone;
    map['coupon_nums'] = couponNums;
    map['comment_nums'] = commentNums;
    map['orders_nums'] = ordersNums;
    map['note_nums'] = noteNums;
    map['wrong_nums'] = wrongNums;
    map['collect_nums'] = collectNums;
    map['integral_nums'] = integralNums;
    map['password'] = password;
    map['grade_id'] = gradeId;
    map['grade_name'] = gradeName;
    map['bean_nums'] = beanNums;
    return map;
  }
}

/// 笔记详情模型
class NoteModel {
  NoteModel({
    this.notesId,
    this.types,
    this.chapterId,
    this.content,
    this.positioning,
    this.noteContent,
    this.color,
    this.chapterName,
    this.isMy,
  });

  NoteModel.fromJson(dynamic json) {
    notesId = json['notes_id'];
    types = json['types'];
    chapterId = json['chapter_id'];
    content = json['content'];
    positioning = json['positioning'];
    // noteContent = json['note_content'];
    noteContent = json['note_content'] != null ? NoteContentModel.fromJson(json['note_content']) : null;
    color = json['color'];
    chapterName = json['chapter_name'];
    isMy = json['is_my'];
  }
  num? notesId;
  num? types;
  num? isMy;
  num? chapterId;
  String? content;
  String? positioning;
  // String? noteContent;
  NoteContentModel? noteContent;
  String? color;
  String? chapterName;

  NoteModel copyWith({
    num? notesId,
    num? types,
    num? isMy,
    num? chapterId,
    String? content,
    String? positioning,
    NoteContentModel? noteContent,
    String? color,
    String? chapterName,
  }) =>
      NoteModel(
        notesId: notesId ?? this.notesId,
        types: types ?? this.types,
        isMy: isMy ?? this.isMy,
        chapterId: chapterId ?? this.chapterId,
        content: content ?? this.content,
        positioning: positioning ?? this.positioning,
        noteContent: noteContent ?? this.noteContent,
        color: color ?? this.color,
        chapterName: chapterName ?? this.chapterName,
      );

  Map<String, dynamic> toJson() {
    final map = <String, dynamic>{};
    map['notes_id'] = notesId;
    map['types'] = types;
    map['is_my'] = isMy;
    map['chapter_id'] = chapterId;
    map['content'] = content;
    map['positioning'] = positioning;
    if (noteContent != null) {
      map['note_content'] = noteContent?.toJson();
    }
    map['color'] = color;
    map['chapter_name'] = chapterName;
    return map;
  }
}

class MediaModel {
  MediaModel({
    this.privacyStatus,
    this.content,
    this.id,
    this.duration = '',
    this.path = '',
    this.currentDuration = '0:00:00'
  });

  MediaModel.fromJson(dynamic json)  {
    privacyStatus = json['privacy_status'];
    content = json['content'];
    id = json['id'];
    duration = '';
    path = '';
    currentDuration = '0:00:00';
  }
  num? privacyStatus;
  String? content;
  late String path;
  num? id;
  late String duration;
  late String currentDuration;
  MediaModel copyWith({
    num? privacyStatus,
    String? content,
    num? id,
    String path = '',
  }) => MediaModel(
    privacyStatus: privacyStatus ?? this.privacyStatus,
    content: content ?? this.content,
    id: id ?? this.id,
  );
  Map<String, dynamic> toJson() {
    final map = <String, dynamic>{};
    map['privacy_status'] = privacyStatus;
    map['content'] = content;
    map['id'] = id;
    return map;
  }

}

class NoteContentModel {
  NoteContentModel({
    this.text,
    this.audio,
    this.image,});

  NoteContentModel.fromJson(dynamic json) {
    text = json['text'] != null ? MediaModel.fromJson(json['text']) : null;
    if (json['audio'] != null) {
      audio = [];
      json['audio'].forEach((v) {
        audio?.add(MediaModel.fromJson(v));
      });
    }
    if (json['image'] != null) {
      image = [];
      json['image'].forEach((v) {
        image?.add(MediaModel.fromJson(v));
      });
    }
  }
  MediaModel? text;
  List<MediaModel>? audio;
  List<MediaModel>? image;
  NoteContentModel copyWith({  MediaModel? text,
    List<MediaModel>? audio,
    List<MediaModel>? image,
  }) => NoteContentModel(  text: text ?? this.text,
    audio: audio ?? this.audio,
    image: image ?? this.image,
  );
  Map<String, dynamic> toJson() {
    final map = <String, dynamic>{};
    if (text != null) {
      map['text'] = text?.toJson();
    }
    if (audio != null) {
      map['audio'] = audio?.map((v) => v.toJson()).toList();
    }
    if (image != null) {
      map['image'] = image?.map((v) => v.toJson()).toList();
    }
    return map;
  }

}




/// 讨论模型
class DiscussModel {
  DiscussModel({
    this.id,
    this.chapterId,
    this.chapterName,
    this.content,
    this.quoteContent,
    this.title,
    this.replyId,
    this.personType,
    this.personId,
    this.goodNum,
    this.replyNum,
    this.createTime,
    this.replacePersonName,
    this.replacePersonPic,
    this.personName,
    this.commentAll,
    this.personPic,
    this.isMy,
  });

  DiscussModel.fromJson(dynamic json) {
    id = json['id'];
    chapterId = json['chapter_id'];
    chapterName = json['chapter_name'];
    // content = json['content'];
    content = json['content'] != null ? NoteContentModel.fromJson(json['content']) : null;
    quoteContent = json['quote_content'];
    title = json['title'];
    replyId = json['reply_id'];
    personType = json['person_type'];
    personId = json['person_id'];
    goodNum = json['good_num'];
    replyNum = json['reply_num'];
    createTime = json['create_time'];
    replacePersonName = json['replace_person_name'];
    replacePersonPic = json['replace_person_pic'];
    personName = json['person_name'];
    personPic = json['person_pic'];
    isMy = json['is_my'];

    if (json['comment_all'] != null) {
      commentAll = [];
      json['comment_all'].forEach((v) {
        commentAll?.add(DiscussModel.fromJson(v));
      });
    }
  }

  num? id;
  num? chapterId;
  String? chapterName;
  NoteContentModel? content;
  String? quoteContent;
  String? title;
  num? replyId;
  num? personType;
  num? personId;
  num? goodNum;
  num? replyNum;
  num? isMy;
  String? createTime;
  String? replacePersonName;
  String? replacePersonPic;
  String? personName;
  String? personPic;
  List<DiscussModel>? commentAll;

  DiscussModel copyWith({
    num? id,
    num? chapterId,
    String? chapterName,
    NoteContentModel? content,
    String? quoteContent,
    String? title,
    num? replyId,
    num? personType,
    num? personId,
    num? goodNum,
    num? replyNum,
    num? isMy,
    String? createTime,
    String? replacePersonName,
    String? replacePersonPic,
    String? personName,
    String? personPic,
    List<DiscussModel>? commentAll,
  }) =>
      DiscussModel(
        id: id ?? this.id,
        chapterId: chapterId ?? this.chapterId,
        chapterName: chapterName ?? this.chapterName,
        content: content ?? this.content,
        quoteContent: quoteContent ?? this.quoteContent,
        title: title ?? this.title,
        replyId: replyId ?? this.replyId,
        personType: personType ?? this.personType,
        personId: personId ?? this.personId,
        goodNum: goodNum ?? this.goodNum,
        replyNum: replyNum ?? this.replyNum,
        isMy: isMy ?? this.isMy,
        createTime: createTime ?? this.createTime,
        replacePersonName: replacePersonName ?? this.replacePersonName,
        replacePersonPic: replacePersonPic ?? this.replacePersonPic,
        personName: personName ?? this.personName,
        personPic: personPic ?? this.personPic,
        commentAll: commentAll ?? this.commentAll,
      );

  Map<String, dynamic> toJson() {
    final map = <String, dynamic>{};
    map['id'] = id;
    map['chapter_id'] = chapterId;
    map['chapter_name'] = chapterName;
    // map['content'] = content;
    if (content != null) {
      map['note_content'] = content?.toJson();
    }
    map['quote_content'] = quoteContent;
    map['title'] = title;
    map['reply_id'] = replyId;
    map['person_type'] = personType;
    map['person_id'] = personId;
    map['good_num'] = goodNum;
    map['reply_num'] = replyNum;
    map['is_my'] = isMy;
    map['create_time'] = createTime;
    map['replace_person_name'] = replacePersonName;
    map['replace_person_pic'] = replacePersonPic;
    map['person_name'] = personName;
    map['person_pic'] = personPic;
    if (commentAll != null) {
      map['comment_all'] = commentAll?.map((v) => v.toJson()).toList();
    }
    return map;
  }
}

/// 帮助中心模型
class HelpCenterModel {
  HelpCenterModel({
    this.id,
    this.helpTitle,
    this.createTime,
  });

  HelpCenterModel.fromJson(dynamic json) {
    id = json['id'];
    helpTitle = json['help_title'];
    createTime = json['create_time'];
  }

  num? id;
  String? helpTitle;
  String? createTime;

  HelpCenterModel copyWith({
    num? id,
    String? helpTitle,
    String? createTime,
  }) =>
      HelpCenterModel(
        id: id ?? this.id,
        helpTitle: helpTitle ?? this.helpTitle,
        createTime: createTime ?? this.createTime,
      );

  Map<String, dynamic> toJson() {
    final map = <String, dynamic>{};
    map['id'] = id;
    map['help_title'] = helpTitle;
    map['create_time'] = createTime;
    return map;
  }
}


/// 帮助中心内容模型
class HelpCenterContentModel {
  HelpCenterContentModel({
    this.id,
    this.helpTitle,
    this.helpContent,
    this.createTime,
    this.updateTime,
  });

  HelpCenterContentModel.fromJson(dynamic json) {
    id = json['id'];
    helpTitle = json['help_title'];
    helpContent = json['help_content'];
    createTime = json['create_time'];
    updateTime = json['update_time'];
  }

  num? id;
  String? helpTitle;
  String? helpContent;
  String? createTime;
  String? updateTime;

  HelpCenterContentModel copyWith({
    num? id,
    String? helpTitle,
    String? helpContent,
    String? createTime,
    String? updateTime,
  }) =>
      HelpCenterContentModel(
        id: id ?? this.id,
        helpTitle: helpTitle ?? this.helpTitle,
        helpContent: helpContent ?? this.helpContent,
        createTime: createTime ?? this.createTime,
        updateTime: updateTime ?? this.updateTime,
      );

  Map<String, dynamic> toJson() {
    final map = <String, dynamic>{};
    map['id'] = id;
    map['help_title'] = helpTitle;
    map['help_content'] = helpContent;
    map['create_time'] = createTime;
    map['update_time'] = updateTime;
    return map;
  }
}

/// 紫荆币模型
class CoinModel {
  CoinModel({
    this.beanName,
    this.beanValue,
    this.priceName,
    this.priceValue,
    this.identifying,
    this.selected = false,
  });

  CoinModel.fromJson(dynamic json) {
    beanName = json['bean_name'];
    beanValue = json['bean_value'];
    priceName = json['price_name'];
    priceValue = json['price_value'];
    identifying = json['identifying'];
    selected = false;
  }
  String? beanName;
  String? beanValue;
  String? priceName;
  String? priceValue;
  String? identifying;
  late bool selected;
  CoinModel copyWith({  String? beanName,
    String? beanValue,
    String? priceName,
    String? priceValue,
    String? identifying,
  }) => CoinModel(  beanName: beanName ?? this.beanName,
    beanValue: beanValue ?? this.beanValue,
    priceName: priceName ?? this.priceName,
    priceValue: priceValue ?? this.priceValue,
    identifying: identifying ?? this.identifying,
  );
  Map<String, dynamic> toJson() {
    final map = <String, dynamic>{};
    map['bean_name'] = beanName;
    map['bean_value'] = beanValue;
    map['price_name'] = priceName;
    map['price_value'] = priceValue;
    map['identifying'] = identifying;
    return map;
  }

}

