part of login;


class LoginPage extends StatefulWidget {
  const LoginPage({Key? key}) : super(key: key);

  @override
  State<LoginPage> createState() => _LoginPageState();
}

class _LoginPageState extends State<LoginPage> {
  final _formKey = GlobalKey<FormState>();
  bool isChecked = false;


  @override
  Widget build(BuildContext context) {
    return GetBuilder<LoginController>(
        init: LoginController(),
        builder:(controller) => GestureDetector(
          onTap: () => Tools.unfocus(),
          child: Scaffold(
              resizeToAvoidBottomInset:true,
            appBar: CustomAppBar(
              systemOverlayStyle: Theme.of(context).brightness == Brightness.light
                  ? SystemUiOverlayStyle.dark
                  : SystemUiOverlayStyle.light,
              backgroundColor: Colors.transparent,
            ),
            // extendBodyBehindAppBar: true,
            body: SafeArea(
              top: false,
              minimum: const EdgeInsets.all(AppTheme.margin).copyWith(
                // top:Screen.statusBar,
                left: 25,
                right: 25,
                bottom: 25
              ),
              child: Column(
                children: [
                  Expanded(
                    child: SingleChildScrollView(
                      child: Form(
                        autovalidateMode: AutovalidateMode.always,
                        onChanged: (){
                          setState(() {
                            print('++++++++++++++++');
                          });
                        },
                        key: _formKey,
                        child: Column(
                          mainAxisAlignment: MainAxisAlignment.spaceBetween,
                          children: [
                            Column(
                              // crossAxisAlignment: CrossAxisAlignment.center,
                              mainAxisAlignment: MainAxisAlignment.center,
                              children: [
                                const SizedBox(height: 120,),
                                Container(
                                  width: 180,
                                  height: 50,
                                  color: Colors.cyan,
                                ),
                                const SizedBox(height:66),
                                //
                                CustomFormInput(
                                  // label: 'Phone',
                                  // required: true,
                                  hintText: '请输入手机号',
                                  keyboardType: TextInputType.number,
                                  controller: controller.phoneInput,
                                  onChanged: (text){
                                    controller.setCanClick();
                                  },
                                ),
                                Gaps.vGaps13,
                                (controller.loginType == 0)?
                                ValueListenableBuilder<bool>(
                                  valueListenable: controller.showPassword,
                                  builder:(context, value, child) => CustomFormInput(
                                    obscureText: !value,
                                    hintText: '请输入密码',
                                    iconData:
                                    value ? Icons.visibility : Icons.visibility_off,
                                    controller: controller.passwordInput,
                                    onChanged: (text){
                                      controller.setCanClick();
                                    },
                                    onIcon: controller.onShowPassword,
                                  ),
                                ):Stack(
                                  alignment: Alignment.centerRight,
                                  children: [
                                    CustomFormInput(
                                      // label: 'Phone',
                                      // required: true,
                                      hintText: '请输入验证码',
                                      keyboardType: TextInputType.number,
                                      controller: controller.codeInput,
                                    ),
                                    Positioned(
                                      right: 10,
                                        child: Row(
                                          children: [
                                            Container(height: 20,width: 1,color: const Color(0xFFEBEBEB),),
                                            Gaps.hGaps10,
                                            GestureDetector(
                                                child: Container(
                                                  padding: const EdgeInsets.symmetric(vertical: 10),
                                                  color: Colors.yellow,
                                                    child: Text(controller.isCounting?'${controller.countDown}':'获取验证码',style: const TextStyle(fontSize: 11,color: AppTheme.primary,height: 1.4),)),
                                              onTap: (){
                                                  controller.start();
                                              },
                                            ),
                                          ],
                                        )
                                    )
                                  ],
                                ),
                                Container(
                                  margin: const EdgeInsets.only(left: 10,right: 10,top: 8.5),
                                  alignment: Alignment.centerLeft,
                                  child: Row(
                                    mainAxisAlignment: MainAxisAlignment.spaceBetween,
                                    children: [
                                      controller.loginType == 0? GestureDetector(
                                          child: const Text('验证码登录',style: TextStyle(fontSize: 13,height: 1.3,color: Colours.c6),),
                                        onTap: (){
                                            controller.updateLoginType(1);
                                        },
                                      ):GestureDetector(
                                          child: const Text('密码登录',style: TextStyle(fontSize: 13,height: 1.3,color: Colours.c6),),
                                        onTap: (){
                                          controller.updateLoginType(0);
                                        },
                                      ),
                                      controller.loginType == 0? GestureDetector(
                                        child: const Text('忘记密码',style: TextStyle(fontSize: 13,height: 1.3,color: Colours.cBlue),),
                                        onTap: (){
                                            context.pushNamed(Routes.forgetPwd);
                                        },
                                      ):const Text('*登录后将自动完成注册',style: TextStyle(fontSize: 13,height: 1.3,color: Colours.c6),),
                                    ],
                                  )
                                ),
                                const SizedBox(height: 30,),
                                CustomGradientButton(
                                  text: '立即登录',
                                  isEnabled: controller.enable,
                                  onPressed: () {
                                    print('11111111111111111');
                                      controller.onLogin(_formKey);
                                  },
                                )
                              ],
                            ),

                          ],
                        ),
                      ),
                    ),
                  ),
                  Row(
                    mainAxisAlignment: MainAxisAlignment.center,
                    children: [
                      GestureDetector(
                        onTap: (){
                          ///TODO: 同意协议
                        },
                        child: Row(
                          children: [
                            Container(
                              width: 10.w,
                              height: 10.w,
                              color: AppTheme.primary,
                            ),
                            Gaps.hGaps10,
                            const Text('我已阅读并同意',style: TextStyle(color: Colours.c9,fontSize:10)),
                          ],
                        ),
                      ),
                      GestureDetector(
                        child: const Text('《用户协议》',style: TextStyle(color: Colours.cBlue,fontSize:10)),
                        onTap: (){
                            context.pushNamed(Routes.terms);
                        },
                      ),
                      GestureDetector(
                        child: const Text('《隐私政策》',style: TextStyle(color: Colours.cBlue,fontSize:10)),
                        onTap: (){
                          context.pushNamed(Routes.terms);
                        },
                      ),
                    ],
                  )
                ],
              ),
            )
          ),
        )
    );
  }
}

