part of reset_pwd;

class ResetPwdPage extends StatefulWidget {
  const ResetPwdPage({Key? key}) : super(key: key);

  @override
  State<ResetPwdPage> createState() => _ResetPwdPageState();
}

class _ResetPwdPageState extends State<ResetPwdPage> {
  @override
  Widget build(BuildContext context) {
    return GetBuilder<ResetPwdController>(
      init: ResetPwdController(),
      builder: (controller) =>Scaffold(
        appBar: AppBar(
          centerTitle: true,
          title: const Text('重置密码'),
        ),
        body: Container(
          margin: const EdgeInsets.only(left: 10,top: 15,right: 10),
          child: Column(
            crossAxisAlignment: CrossAxisAlignment.start,
            children: [
              ValueListenableBuilder<bool>(
                valueListenable: controller.showPassword,
                builder:(context, value, child) => CustomFormInput(
                  obscureText: !value,
                  hintText: '请输入新密码',
                  iconData:
                  value ? Icons.visibility : Icons.visibility_off,
                  controller: controller.pwdInput,
                  onChanged: (text){
                    controller.setCanClick();
                  },
                  onIcon: controller.onShowPassword,
                ),
              ),
              ValueListenableBuilder<bool>(
                valueListenable: controller.showPassword2,
                builder:(context, value, child) => CustomFormInput(
                  obscureText: !value,
                  hintText: '请再次输入密码',
                  iconData:
                  value ? Icons.visibility : Icons.visibility_off,
                  controller: controller.pwd2Input,
                  onChanged: (text){
                    controller.setCanClick();
                  },
                  onIcon: controller.onShowPassword2,
                ),
              ),
              Container(
                margin: const EdgeInsets.only(left: 5,top: 5),
                child: const Text('密码必须是6-20个英文字母、数字或符号',style: TextStyle(fontSize: 10,color: Colours.c9),),
              )
            ],
          ),
        ),
      ),
    );
  }
}
