part of book_pay;

class BookPayPage extends StatefulWidget {
  final List<CourseModel> buy;
  const BookPayPage({
    Key? key,
    required this.buy
  }) : super(key: key);

  @override
  State<BookPayPage> createState() => _BookPayPageState();
}

class _BookPayPageState extends State<BookPayPage> {

  @override
  Widget build(BuildContext context) {
    return WillPopScope(
      onWillPop: () async {
        context.pop(true);
        return false;
      },
      child: GetBuilder<BookPayController>(
        init: BookPayController(buy: widget.buy,context: context),
        builder: (controller) => Stack(
          children: [
            Scaffold(
              backgroundColor: Colours.cF9,
              appBar: AppBar(title: const Text('支付'),),
              body: SingleChildScrollView(
                child: Column(
                  children: [
                    ListView.builder(
                      physics: const NeverScrollableScrollPhysics(),
                      shrinkWrap:true,
                      itemBuilder: (BuildContext context, int index){
                        return BuildItem(model: controller.buy![index],);
                      },
                      itemCount: controller.buy!.length,
                    ),
                    controller.showModel.couponSwitch =='0' && controller.showModel.integralSwitch =='0'?const SizedBox():SizedBox(height: 10.w,),
                    Visibility(
                      visible: controller.showModel.couponSwitch =='0' && controller.showModel.integralSwitch =='0'?false:true,
                      child: Container(
                        margin: EdgeInsets.only(left: 10.w,right: 10.w),
                        decoration: BoxDecoration(
                            borderRadius:BorderRadius.circular(8.w),
                            color: Colors.white,
                            boxShadow: [
                              BoxShadow(
                                color: Colours.cC7.withOpacity(0.5),
                                spreadRadius: 2.w,
                                blurRadius: 5.w,
                                offset: Offset(3.w, 0), // changes the position of the shadow
                              ),
                            ]
                        ),
                        child: Column(
                          children: [
                            controller.showModel.couponSwitch =='0'?const SizedBox():GestureDetector(
                              child: _buildCouponWidget(controller,title: '优惠券',icon: 'assets/images/pay_coupon.png',),
                              onTap: (){
                                context.pushNamed(Routes.payCoupon,extra: controller);
                              },
                            ),
                            Container(height: 0.5.w,color: Colours.cF0,margin: EdgeInsets.only(left: 10.w),),
                            controller.showModel.integralSwitch =='0'?const SizedBox(): GestureDetector(
                              child: _buildPointWidget(controller,title: '积分抵扣',icon: 'assets/images/pay_point.png',),
                              onTap: (){
                                if(controller.creditPointModel.deductibleIntegral !=0){
                                  context.pushNamed(Routes.creditPoints);
                                }
                              },
                            ),
                          ],
                        ),
                      ),
                    ),
                    Container(
                      margin: EdgeInsets.only(left: 10.w,right: 10.w,top: 10.w),
                      decoration: BoxDecoration(
                          borderRadius:BorderRadius.circular(8.w),
                          color: Colors.white,
                          boxShadow: [
                            BoxShadow(
                              color: Colours.cC7.withOpacity(0.5),
                              spreadRadius: 2.w,
                              blurRadius: 5.w,
                              offset: const Offset(3, 0), // changes the position of the shadow
                            ),
                          ]
                      ),
                      child: ListView.builder(
                        physics: const NeverScrollableScrollPhysics(),
                        padding: const EdgeInsets.symmetric(horizontal: 10),
                        shrinkWrap:true,
                        itemBuilder: (BuildContext context, int index){
                          PayModel model = controller.pays[index];
                          return GestureDetector(
                              onTap: (){
                                controller.setPayModel(model);
                              },
                              child: BuildPayWay(model:model,));
                        },
                        itemCount: controller.pays.length,
                      ),
                    ),
                  ],
                ),
              ),
              bottomNavigationBar:  SafeArea(child:BuildPayCount(
                  payTap: (){
                    Console.log('--------------支付------------------');
                    controller.createOrder();
                  },
                  showTap: (){
                    controller.show();
                    Console.log('--------------展示优惠详情------------------');
                  }, controller: controller,
              )),
            ),
            controller.showDetail?Positioned(
              left: 0.w,
              bottom: 50.w,
              right: 0.w,
              top: 0.w,
              child: GestureDetector(
                onTap: (){
                  controller.show();
                },
                child: Container(
                  color:const  Color(0xFF000000).withOpacity(0.5),
                  child: Align(
                    alignment: Alignment.bottomCenter,
                    child: ClipRRect(
                      borderRadius: BorderRadius.only(topRight: Radius.circular(8.w),topLeft: Radius.circular(8.w)),
                      child: Container(
                        height: 210.w,
                        color: Colors.white,
                        child: _buildPayDetail(controller),
                      ),
                    ),
                  ),
                ),
              ),
            ):const SizedBox()
          ],
        )
      ),
    );
  }

  Widget _buildPayDetail(BookPayController controller){
    return Column(
      children: [
        Stack(
          children: [
            Container(
              // color: Colors.red,
              padding: EdgeInsets.all(15.w),
              child: const Row(
                mainAxisAlignment: MainAxisAlignment.center,
                children: [
                  Text('应付明细',textAlign:TextAlign.center,style: TextStyle(fontSize: 19,height: 1.1,color: Colours.c3,fontWeight: Fonts.boldSemi),),
                ],
              ),
            ),
            Positioned(
              right: 10.w,
              top: 10.w,
              child: GestureDetector(
                onTap: (){
                  controller.show();
                },
                child: SizedBox(
                  width: 20.w,
                  height: 20.w,
                  child: Image.asset('assets/images/close.png'),
                ),
              ),
            )
          ],
        ),
        SizedBox(height: 20.w,),
        Container(
          margin: EdgeInsets.symmetric(horizontal: 15.w),
          child: Column(
            children: [
              Row(
                mainAxisAlignment: MainAxisAlignment.spaceBetween,
                children: [
                  Text('总价',style: TextStyle(fontSize: 16.w,height: 1.5,color: Colours.c3,fontWeight: Fonts.medium),),
                  Text('￥${controller.finalPrice}',style: TextStyle(fontSize: 15.w,height: 1.5,color: AppTheme.primary,fontWeight: Fonts.medium),)
                ],
              ),
              Gaps.vGaps15,
              controller.showModel.couponSwitch =='1'? Row(
                mainAxisAlignment: MainAxisAlignment.spaceBetween,
                children: [
                  Text('优惠券抵扣',style: TextStyle(fontSize: 13.w,height: 1.5,color: Colours.c9,),),
                  Text('减￥${controller.useCouponModel.reducedPrice}',style: TextStyle(fontSize: 13.w,height: 1.5,color: AppTheme.primary),)
                ],
              ):const SizedBox(),
              Gaps.vGaps10,
              controller.showModel.integralSwitch =='1'? Row(
                mainAxisAlignment: MainAxisAlignment.spaceBetween,
                children: [
                  Text('积分抵扣',style: TextStyle(fontSize: 13.w,height: 1.5,color: Colours.c9,),),
                  Text('减￥${controller.useCreditPoint?controller.creditPointModel.deductibleAmount:'0.00'}',style: TextStyle(fontSize: 13.w,height: 1.5,color: AppTheme.primary),)
                ],
              ):const SizedBox()
            ],
          ),
        )
      ],
    );
  }

  // 优惠券选择
  Widget _buildCouponWidget(BookPayController controller,{
    required String title,
    required String icon,
  }){
    return Container(
      margin: EdgeInsets.only(left: 13.w,right: 13.w),
      color: Colors.white,
      child: Row(
        mainAxisAlignment: MainAxisAlignment.spaceBetween,
        children: [
          Row(
            children: [
              Container(
                margin: EdgeInsets.symmetric(vertical: 12.w),
                // color: Colors.cyan,
                width:20.w,
                height:20.w,
                child: Image.asset(icon),
              ),
              SizedBox(width: 7.w,),
              Text(title,style:  TextStyle(fontSize: 14.w,color: Colours.c3,height: 1.1)),
            ],
          ),
          Row(
            children: [
              controller.useCouponModel.couponId!=0?Row(
                children: [
                  Text('「满${controller.useCouponModel.normPrice}减${controller.useCouponModel.reducedPrice}」-￥${controller.useCouponModel.reducedPrice}',style: TextStyle(fontSize: 13.w,height: 1.3,color: AppTheme.primary),),
                  Gaps.hGaps10,
                  GestureDetector(
                      child: Image.asset('assets/images/unused_coupon.png'),
                    onTap: (){
                      CouponModel model = CouponModel(couponRecId: 0,couponId: 0);
                        controller.setUseCoupon(model);
                    },
                  )
                ],
              ):controller.couponNumModel.availableNum ==0?Text('暂无可用',style: TextStyle(fontSize:13.w,color: Colours.c9,height:1.4)):Text('${controller.couponNumModel.availableNum??''}个可用',style: TextStyle(fontSize:13.w,color: AppTheme.primary,height:1.4)),
              Gaps.hGaps10,
              SizedBox(
                // color: Colors.cyan,
                width:5.w,
                height:8.w,
                child: Image.asset('assets/images/right_arrow.png'),
              ),
            ],
          )
        ],
      ),
    );
  }


  // 积分选择
  Widget _buildPointWidget(BookPayController controller,{
    required String title,
    required String icon,
  }){
    return Container(
      margin: EdgeInsets.only(left: 13.w,right: 13.w),
      color: Colors.white,
      child: Row(
        mainAxisAlignment: MainAxisAlignment.spaceBetween,
        children: [
          Row(
            children: [
              Container(
                margin: EdgeInsets.symmetric(vertical: 12.w),
                // color: Colors.cyan,
                width:20.w,
                height:20.w,
                child: Image.asset(icon),
              ),
              SizedBox(width: 7.w,),
              Text(title,style:  TextStyle(fontSize: 14.w,color: Colours.c3,height: 1.1)),
            ],
          ),
          Row(
            mainAxisAlignment: MainAxisAlignment.center,
            children: [
              controller.useCreditPoint?Text('-￥${controller.creditPointModel.deductibleAmount}',style: TextStyle(fontSize:13.w,color: AppTheme.primary,height:1.4),)
                  : Text( controller.creditPointModel.deductibleIntegral ==0?'不可用':'去选择',style: TextStyle(fontSize:13.w,color: Colours.c9,height:1.4)),
              Gaps.hGaps10,
              SizedBox(
                // color: Colors.cyan,
                width:5.w,
                height:8.w,
                child: Image.asset('assets/images/right_arrow.png'),
              ),
            ],
          )
        ],
      ),
    );
  }

}
