part of user_order_coin_completed;

/// 紫荆币待支付
class UserOrderCoinCompletedPage extends StatefulWidget {
  final String orderNum; // 订单编号
  const UserOrderCoinCompletedPage({Key? key, required this.orderNum})
      : super(key: key);

  @override
  State<UserOrderCoinCompletedPage> createState() =>
      _UserOrderCoinAwaitingState();
}

class _UserOrderCoinAwaitingState extends State<UserOrderCoinCompletedPage> {
  late UserOrderCoinCompletedController myController;

  @override
  void initState() {
    myController = Get.put(UserOrderCoinCompletedController(context));
    myController.updateOrderNum(widget.orderNum);
    super.initState();
  }

  @override
  Widget build(BuildContext context) {
    return WillPopScope(
      onWillPop: () async {
      context.pop(true);
      return false;
    },
    child:  FutureBuilder(
      future: myController.getOrderInfo(),
      builder: (context, snapshot) {
        if (snapshot.connectionState == ConnectionState.waiting) {
          return Scaffold(
            appBar: AppBar(
              centerTitle: true,
              title: const Text('已完成'),
            ),
          );
        } else {
          return WillPopScope(
            onWillPop: () async {
              context.pop(true);
              return false;
            },
            child: Scaffold(
              appBar: CustomAppBar(
                title: const Text('已完成'),
                actions: [],
              ),
              body: Column(
                children: [
                  Container(
                    margin: EdgeInsets.symmetric(
                        horizontal: AppTheme.margin,
                        vertical: AppTheme.margin),
                    decoration: BoxDecoration(
                      borderRadius: BorderRadius.circular(8.w),
                      color: Colors.white,
                      boxShadow: [
                        BoxShadow(
                          color: Colours.cC7.withOpacity(0.5),
                          offset: Offset(3.w, 0),
                          blurRadius: 10.w,
                          spreadRadius: 0.w,
                        ),
                      ],
                    ),
                    child: ClipRRect(
                      borderRadius: BorderRadius.circular(8.w),
                      child: Column(
                        mainAxisAlignment: MainAxisAlignment.start,
                        mainAxisSize: MainAxisSize.min,
                        children: [
                          Padding(
                            padding: EdgeInsets.only(
                                left: 12.0.w,
                                top: 17.5.w,
                                bottom: 12.0.w),
                            child: Row(
                              mainAxisAlignment:
                              MainAxisAlignment.start,
                              crossAxisAlignment:
                              CrossAxisAlignment.start,
                              children: [
                                Image.asset(
                                  'assets/images/coin.png',
                                  // fit: BoxFit.cover, // 设置适应方式为充满
                                  width: 42.0.w,
                                  height: 42.0.w,
                                ),
                                Expanded(
                                  child: Padding(
                                    padding:
                                    EdgeInsets.only(right: 16.5.w),
                                    child: Column(
                                      mainAxisAlignment:
                                      MainAxisAlignment
                                          .spaceBetween,
                                      crossAxisAlignment:
                                      CrossAxisAlignment.end,
                                      // 下面的Text靠左
                                      children: [
                                        Text(
                                          '充值${myController.model.bean}紫荆币',
                                          style: TextStyle(
                                            color: Colours.c3,
                                            fontWeight: Fonts.bold,
                                            fontSize: 13.w,
                                          ),
                                          maxLines: 2,
                                          overflow: TextOverflow
                                              .ellipsis, // 超过部分显示省略号
                                        ),
                                        SizedBox(height: 9.w),
                                        // Text(
                                        //   "需付款 ¥${myController.model.finalTotalPrice}",
                                        //   style: TextStyle(
                                        //     color: Colours.cAB1941,
                                        //     fontWeight: Fonts.bold,
                                        //     fontSize: 14.w,
                                        //   ),
                                        // ),
                                      ],
                                    ),
                                  ),
                                ),
                              ],
                            ),
                          ),
                          Container(
                            color: Colours.cLine,
                            margin: EdgeInsets.only(
                                left: 10.w, right: 10.w, bottom: 12.w),
                            height: 1.w,
                          ),
                          Container(
                            padding: EdgeInsets.only(
                                left: 11.5.w,
                                bottom: 8.w,
                                right: 23.5.w),
                            child: Column(
                              mainAxisAlignment:
                              MainAxisAlignment.spaceEvenly,
                              children: myController.orderAwaitings
                                  .map((model) {
                                return Padding(
                                  padding: EdgeInsets.only(top: 12.w),
                                  child: Row(
                                    mainAxisAlignment:
                                    MainAxisAlignment.spaceBetween,
                                    children: [
                                      Text(
                                        model.name,
                                        style: TextStyle(
                                            fontSize: 13.w,
                                            height: 1.6.w,
                                            color: Colours.c9),
                                      ),
                                      Text(
                                        model.value.toString(),
                                        style: TextStyle(
                                            fontSize: 13.w,
                                            height: 1.6.w,
                                            color: Colours.c3),
                                      ),
                                    ],
                                  ),
                                );
                              }).toList(),
                            ),
                          ),
                          SizedBox(
                            height: 13.5.w,
                          ),
                        ],
                      ),
                    ),
                  ),
                  SizedBox(
                    height: 11.5.w,
                  ),
                ],
              ),
            ),
          );
        }
      },
    ),
    );
  }
}
