part of routes;

abstract class Routes {
  static final RouteObserver<Route> observer = RouteObservers();
  static List<String> history = [];

  static const splash = 'splash';
  static const main = 'main';
  static const ad = 'ad';
  static const login = 'login';
  static const web = 'web';
  static const about = 'about';
  static const bookPay = 'book_pay';


  static final GoRouter config = GoRouter(
      // initialLocation: '/$splash',
      initialLocation: '/',
      observers: [observer],
      routes: [
        GoRoute(
            path: '/$splash',
            name: splash,
            pageBuilder: (context, state) =>CupertinoPage(
                name: state.uri.toString(),
                key: state.pageKey,
                child: const SplashPage(),
            ),
        ),
        GoRoute(
            path: '/',
            name: main,
            pageBuilder: (context, state) =>CupertinoPage(
                name: state.uri.toString(),
                key: state.pageKey,
                child: const MainPage()
            )
        ),
        GoRoute(
            path: '/$ad',
            name: ad,
            pageBuilder: (context, state) =>CupertinoPage(
                name: state.uri.toString(),
                key: state.pageKey,
                child: const AdPage()
            )
        ),
        GoRoute(
            path: '/$login',
            name: login,
            pageBuilder: (context, state) =>CupertinoPage(
                name: state.uri.toString(),
                key: state.pageKey,
                child: const LoginPage()
            )
        ),
        GoRoute(
            path: '/$web',
            name: web,
            pageBuilder: (context, state) =>CupertinoPage(
                name: state.uri.toString(),
                key: state.pageKey,
                child: const WebPage()
            )
        ),
        GoRoute(
            path: '/$about',
            name: about,
            pageBuilder: (context, state) =>CupertinoPage(
                name: state.uri.toString(),
                key: state.pageKey,
                child: const AboutPage()
            )
        ),
        GoRoute(
            path: '/$bookPay',
            name: bookPay,
            pageBuilder: (context, state) =>CupertinoPage(
                name: state.uri.toString(),
                key: state.pageKey,
                child: const BookPayPage()
            )
        )
      ]
  );

}