part of web;

class ReadPage extends StatefulWidget {
  const ReadPage({Key? key}) : super(key: key);

  @override
  State<ReadPage> createState() => _ReadPageState();
}

class _ReadPageState extends State<ReadPage> {

  int currentIndex = 0;
  final GlobalKey webViewKey = GlobalKey();
  InAppWebViewController? webViewController;
  late ContextMenu contextMenu;
  @override
  void initState() {
    super.initState();
  }
  @override
  Widget build(BuildContext context) {
    return GetBuilder<ReadController>(
      init: ReadController(),
      builder: (readController) => Scaffold(

       body: Container(
         color: Colors.white,
         child: Stack(
           children: [
             Container(
               height: 40,
               width: double.infinity,
               color: Colors.lightBlue,
             ),
             InAppWebView(
               initialUrlRequest: URLRequest(
                 url: Uri.parse('http://192.168.11.39:5500/'),
               ),
               onWebViewCreated: (InAppWebViewController controller) {
                 webViewController = controller;
               },
               onLoadStop: (controller, url) {
                 controller.addJavaScriptHandler(handlerName: 'onTap', callback: (args){
                   readController.setShow(readController.show);

                 });
                 controller.evaluateJavascript(source: '''
                    document.addEventListener('click', function() {
                      window.flutter_inappwebview.callHandler('onTap');
                    });
                  ''');
               },
             ),
             AnimatedPositioned(
               duration: readController.controller.duration!,
               curve: Curves.easeInOut,
               top: readController.show ? 0 : -100, // 负值隐藏，0 显示
               left: 0,
               right: 0,
               height: 100,
               child: Container(
                 color: Colors.limeAccent,
                 alignment: Alignment.center,
                 child: Text('top View'),
               ),
             ),
             Positioned(
               left: 0,
               right: 0,
               top: 0,
               bottom: 49 + MediaQuery.of(context).viewInsets.bottom,
               child: _showContent(readController,currentIndex)
             ),
             AnimatedPositioned(
               duration: readController.controller.duration!,
               curve: Curves.easeInOut,
               bottom: readController.show ? 0 : -49 - MediaQuery.of(context).viewInsets.bottom, // 负值隐藏，0 显示
               left: 0,
               right: 0,
               height: 49,
               child: Container(
                 color: Colors.limeAccent,
                 alignment: Alignment.center,
                 child: BottomNavigationBar(
                   currentIndex: currentIndex,
                   onTap: (index){
                     setState(() {
                       currentIndex = index;
                     });
                     // _showBottomSheet(context, index);
                   },
                   items: [
                     BottomNavigationBarItem(
                       label: '目录',
                       icon: Image.asset(
                         'assets/images/category_unselect.png',
                       ),
                       activeIcon: Image.asset(
                         'assets/images/category_select.png',
                       ),
                     ),
                     BottomNavigationBarItem(
                       label: '笔记',
                       icon: Image.asset(
                         'assets/images/note_unselect.png',
                       ),
                       activeIcon: Image.asset(
                         'assets/images/note_select.png',
                       )
                     ),
                     BottomNavigationBarItem(
                       label: '讨论',
                       icon: Image.asset(
                         'assets/images/discuss_unselect.png',
                       ),
                       activeIcon: Image.asset(
                         'assets/images/discuss_select.png',
                       )
                     ),
                   ],
                 )
               ),
             ),

           ],
         ),
       ),
      ),
    );

  }
  Widget _showContent(ReadController controller,int index) {
    print('++++++++++++++++++++++++$index');
    if (controller.show){
      if (index == 0){
        return Container(
          color: Color(0xFF000000).withOpacity(0.5),
          padding: EdgeInsets.only(top: MediaQuery.of(context).size.height * 0.2),
          child: ClipRRect(
            borderRadius: BorderRadius.only(topRight: Radius.circular(8.w),topLeft: Radius.circular(8.w)),
            child: Container(
              color: Colors.white,
              child: ReadCategoryPage(controller: controller,),
            ),
          ),
          // child: ReadCategoryPage(),
        );
      }
      else if (index == 1){
        return Container(
          color: Color(0xFF000000).withOpacity(0.5),
          padding: EdgeInsets.only(top: MediaQuery.of(context).size.height * 0.2),
          child: ClipRRect(
            borderRadius: BorderRadius.only(topRight: Radius.circular(8.w),topLeft: Radius.circular(8.w)),
            child: Container(
              color: Colors.white,
              child: ReadNotePage(),
            ),
          ),
          // child: ReadCategoryPage(),
        );
      }
      else if (index == 2){
        return Container(
          color: Color(0xFF000000).withOpacity(0.5),
          padding: EdgeInsets.only(top: MediaQuery.of(context).size.height * 0.2),
          child: ClipRRect(
            borderRadius: BorderRadius.only(topRight: Radius.circular(8.w),topLeft: Radius.circular(8.w)),
            child: Container(
              color: Colors.white,
              child: ReadNotePage(),
            ),
          ),
          // child: ReadCategoryPage(),
        );
      }
    }
    return const SizedBox();
  }
}
