part of book_category;

class BuildItem extends StatefulWidget {
  final ChapterModel model;
  final String bookId;
  final BookDetailModel bookDetails;
  final void Function(ChapterModel model) onTap;
  const BuildItem({
    Key? key,
    required this.model,
    required this.bookId,
    required this.bookDetails,
    required this.onTap
  }) : super(key: key);

  @override
  State<BuildItem> createState() => _BuildItemState();
}

class _BuildItemState extends State<BuildItem> {
  @override
  Widget build(BuildContext context) {
    return Column(
      children: [
        /// 章节名称容器
        GestureDetector(
          onTap: (){
            // 如果章下面没有节 点击才会跳转
            if (widget.model.children!.isEmpty){
              widget.onTap(widget.model);
              // context.pushNamed(Routes.web,queryParameters: {'book_id': widget.bookDetails.bookId.toString(),'chapter_id': widget.model.id.toString(),'chapter_name':widget.model.name.toString()},extra: widget.bookDetails);
            }
            // setState(() {
            //   widget.model.selected = !widget.model.selected;
            // });
          },
          child: Container(
            padding: EdgeInsets.symmetric(horizontal: 15.w),
            height: 30.w,
            color: Colors.white,
            child: Row(
              mainAxisAlignment: MainAxisAlignment.spaceBetween,
              crossAxisAlignment: CrossAxisAlignment.center,
              children: [
                Row(
                  crossAxisAlignment: CrossAxisAlignment.center,
                  children: [
                    Text(widget.model.name??'',style: TextStyle(fontSize: 14.w,color: widget.model.seen ==0? Colours.c3:Colours.c9,fontWeight: Fonts.medium,height: 2),),
                    Gaps.hGaps5,
                    widget.model.isReading == 1? Container(
                      margin: const EdgeInsets.fromLTRB(0, 6, 0, 0),
                      height: 18,
                      width: 18,
                      alignment: Alignment.center,
                      decoration: BoxDecoration(
                        borderRadius: BorderRadius.circular(8.5.w),
                        border: Border.all(width:1,color: AppTheme.primary)
                      ),
                      child: Text('试',style: TextStyle(fontSize: 11.w,color: AppTheme.primary),),
                    ):const SizedBox(),
                  ],
                ),
                Transform.rotate(
                    angle: widget.model.selected?0:-90 * (3.141592653589793 / 180),
                    child: GestureDetector(
                      onTap: (){
                        setState(() {
                          widget.model.selected = !widget.model.selected;
                        });
                      },
                      child: Container(
                        width: 20.w,
                        height: 20.w,
                        // color: Colors.red,
                        child: Image.asset('assets/images/down.png')
                      ),
                    )
                )

              ],
            )
          ),
        ),
        /// 节的名称容器
        Visibility(
          visible: widget.model.selected,
            child: ListView.builder(
              shrinkWrap: true,
              physics: const NeverScrollableScrollPhysics(),
                itemBuilder: (BuildContext context, int index){
                  ChapterModel model = widget.model.children![index];
                  return GestureDetector(
                    onTap: (){
                      widget.onTap(model);
                      // context.pushNamed(Routes.web,queryParameters: {'book_id': widget.bookDetails.bookId.toString(),'chapter_id':model.id.toString(),'chapter_name':model.name.toString()},extra: widget.bookDetails);
                    },
                    child: _buildSection(model)
                  );
                },
                itemCount: widget.model.children!.length,
            )
        )
      ],
    );
  }

  Widget _buildSection(ChapterModel model){
    return Container(
      color: Colors.white,
      padding: EdgeInsets.only(left: 60.w,bottom: 4.w),
      child: Text(model.name??'',style:TextStyle(fontSize: 14.w,color: model.seen ==0? Colours.c3:Colours.c9,height: 2),),
    );
  }
}
