part of user_discuss_des;

class BuildItem extends StatelessWidget {
  final CourseModel model;
  const BuildItem({
    Key? key,
    required this.model,
  }) : super(key: key);

  @override
  Widget build(BuildContext context) {
    return Container(
      margin: const EdgeInsets.all(10),
      decoration: BoxDecoration(
        borderRadius: BorderRadius.circular(8),
        color: Colors.white,
        boxShadow: [
          BoxShadow(
            color: const Color(0xFFC7C7C7).withOpacity(0.5),
            offset: const Offset(3, 0),
            blurRadius: 10.w,
            spreadRadius: 0.w,
          ),
        ],
      ),
      padding: const EdgeInsets.symmetric(horizontal: 10),
      child: Column(
        children: [
          Container(
            padding: const EdgeInsets.only(top: 12,bottom: 15),
            // color: Colors.red,
            child: Row(
              crossAxisAlignment: CrossAxisAlignment.start,
              children: [
                Container(
                  height: 87,
                  width: 73,
                  color: Colors.cyan,
                ),
                Container(
                  height: 87,
                  margin: const EdgeInsets.only(left: 13),
                  // color: Colors.green,
                  child: Column(
                    mainAxisAlignment: MainAxisAlignment.spaceBetween,
                    crossAxisAlignment: CrossAxisAlignment.start,
                    children: [
                      Column(
                        crossAxisAlignment: CrossAxisAlignment.start,
                        children: [
                          Text(model.bookName??'',style: const TextStyle(fontSize: 14,height: 1.5,fontWeight: Fonts.medium,color: Colours.c3),),
                          Text(model.authors??'',style: const TextStyle(fontSize: 12,height: 1.5,color: Colours.c6),),
                        ],
                      ),
                      Text('${model.commentNum.toString()}个讨论',style: const TextStyle(fontSize: 11,height: 1.5,color: AppTheme.primary)),
                    ],
                  ),
                )
              ],
            ),
          )
        ],
      ),
    );
  }
}
