part of help_center;


class HelpCenterPage extends StatefulWidget {
  const HelpCenterPage({Key? key}) : super(key: key);

  @override
  State<HelpCenterPage> createState() => _HelpCenterPageState();
}

class _HelpCenterPageState extends State<HelpCenterPage> {
  @override
  Widget build(BuildContext context) {
    return GetBuilder<HelpCenterController>(
        init: HelpCenterController(),
        builder: (controller) => Scaffold(
          appBar: AppBar(
            centerTitle: true,
            title: const Text('帮助中心'),
          ),
          body: CustomPullScrollView(
            controller: controller.refreshController,
            onRefresh: controller.onRefresh,
            onLoading: controller.onLoading,
            child: ListView.builder(
              itemCount: controller.helpCenters.length,
              itemBuilder: (BuildContext context, int index){
                HelpCenterModel model = controller.helpCenters[index];
                return GestureDetector(
                  child: BuildItem(model: model,),
                  onTap: (){
                    context.pushNamed(Routes.helpCenterContent,queryParameters: {'id': model.id.toString(),'title':model.helpTitle});
                  },

                );
              }),
          ),
        ));
  }
}
