part of user_notes_des;

class BuildLine extends StatelessWidget {
  final NoteModel model;
  const BuildLine({
    Key? key,
    required this.model
  }) : super(key: key);

  @override
  Widget build(BuildContext context) {
    return Container(
      margin: const EdgeInsets.only(left: 10,right: 10,top: 10),
      padding: const EdgeInsets.all(10),
      decoration: BoxDecoration(
        borderRadius: BorderRadius.circular(4),
        color: Colors.white,
        boxShadow: [
          BoxShadow(
            color: const Color(0xFFC7C7C7).withOpacity(0.5),
            offset: const Offset(1.5, 0),
            blurRadius: 7.w,
            spreadRadius: 0.w,
          ),
        ],
      ),
      child: Column(
        crossAxisAlignment: CrossAxisAlignment.start,
        children: [
          Text(model.content??'',style: const TextStyle(
            fontSize: 14,
            height: 1.5,
            color: Colours.c3,
            decoration: TextDecoration.underline,
            decorationColor: Colors.red,
            decorationThickness: 2
          ),),
          Gaps.vGaps8,
          Container(
            width: double.infinity,
            padding: const EdgeInsets.symmetric(vertical: 5,horizontal: 10),
            color: Colours.cF8,
            child: Text(model.chapterName??'',style: const TextStyle(fontSize: 12,height: 1.5,color: Colours.c9),),
          )
        ],
      ),
    );
  }
}
