part of version;


class VersionPage extends StatefulWidget {
  const VersionPage({Key? key}) : super(key: key);

  @override
  State<VersionPage> createState() => _VersionPageState();
}

class _VersionPageState extends State<VersionPage> {
  @override
  Widget build(BuildContext context) {
    return GetBuilder<VersionController>(
        init: VersionController(),
        builder: (controller) => Scaffold(
          appBar: AppBar(
            centerTitle: true,
            title: const Text('版本介绍'),
          ),
          body: CustomPullScrollView(
            controller: controller.refreshController,
            onRefresh: controller.onRefresh,
            onLoading: controller.onLoading,
            child: ListView.builder(

              itemCount: controller.versions.length,
              itemBuilder: (BuildContext context, int index){
                VersionModel model = controller.versions[index];
                return GestureDetector(
                  child: BuildItem(model: model,),
                  onTap: (){
                    context.pushNamed(Routes.versionDes,extra: model);
                  },

                );
              }),
          ),
        ));
  }
}
