part of user_order;

class BuildListPage extends StatefulWidget {
  final int tag;
  // final List<OrderListModel> models;
  // final UserOrderController controller;
  // final BuildContext context;

  const BuildListPage({
    Key? key,
    required this.tag,
    // required this.models,
    // required this.controller,
    // required this.context,
  }) : super(key: key);

  @override
  State<BuildListPage> createState() => _BuildListPageState();
}

class _BuildListPageState extends State<BuildListPage>
    with AutomaticKeepAliveClientMixin {
  late UserOrderController myController;

  @override
  void initState() {
    // myController =  Get.put(UserOrderController(widget.tag));
    super.initState();
  }

  @override
  Widget build(BuildContext context) {
    return GetBuilder<UserOrderController>(
      tag: widget.tag.toString(),
      init: UserOrderController(widget.tag),
      builder: (controller) => CustomPullScrollView(
        controller: controller.refreshController,
        onRefresh: controller.onRefresh,
        onLoading: controller.onLoading,
        child: controller.orderList.isEmpty?Container(
          padding: EdgeInsets.only(top: 110.w),
          alignment: Alignment.center,
          child: Column(
            crossAxisAlignment: CrossAxisAlignment.center,
            children: [
              SizedBox(height: 152.w, width: 195.w,
                child: Image.asset( 'assets/images/none.png',),),
              SizedBox(height: 13.w,),
            ],
          ),
        ):ListView.builder(
          itemBuilder: (BuildContext context, int index) {
            OrderListModel model = controller.orderList[index];
            // OrderListModel model = widget.models[index];
            if (model.types == 2) {
              return BuiltCoin(model: model,controller: controller,);
            } else {
              if (model.status == 1) {
                return BuiltAwaiting(model: model,controller: controller,);
              } else if (model.status == 2) {
                return BuiltCanceled(model: model,);
              } else if (model.status == 3) {
                return BuiltCompleted(model: model,controller: controller,);
              } else if (model.status == 4) {
                return BuiltRefunded(model: model,);
              }
            }
          },
          itemCount: controller.orderList.length,
          // itemCount: widget.models.length,
        ),
      ),
    );
  }

  @override
  bool get wantKeepAlive => true;
}
