part of user_set;

class UserSetPage extends StatefulWidget {
  const UserSetPage({Key? key}) : super(key: key);

  @override
  State<UserSetPage> createState() => _UserSetPageState();
}

class _UserSetPageState extends State<UserSetPage> {
  late UModel _getModel;
  // String url =
  //     "https://imtt.dd.qq.com/16891/apk/FA48766BA12A41A1D619CB4B152889C6.apk?fsname=com.estrongs.android.pop_4.2.3.3_10089.apk&csr=1bbd";

  @override
  Widget build(BuildContext context) {
    return Scaffold(
      appBar: AppBar(
        centerTitle: true,
        title: const Text('设置'),
      ),
      body: Column(
        children: [
          Container(
            margin: EdgeInsets.symmetric(vertical: 10.w, horizontal: 10.w),
            padding: EdgeInsets.only(right: 10.w),
            decoration: BoxDecoration(
              borderRadius: BorderRadius.circular(8.w),
              color: Colors.white,
              boxShadow: [
                BoxShadow(
                  color: const Color(0xFFC7C7C7).withOpacity(0.5),
                  offset: Offset(3.w, 0),
                  blurRadius: 10.w,
                  spreadRadius: 0.w,
                ),
              ],
            ),
            child: Column(
              crossAxisAlignment: CrossAxisAlignment.start,
              children: [
                GestureDetector(
                  onTap: () async {
                    clearCache();
                  },
                  child: Container(
                    color: Colors.white,
                    margin: EdgeInsets.only(left: 15.w),
                    height: 45.w,
                    alignment: Alignment.centerLeft,
                    child: Text('清除缓存',
                        style: TextStyle(fontSize: 14.w, color: Colours.c3)),
                  ),
                ),
                Container(
                  margin: EdgeInsets.only(left: 10.w),
                  height: 0.5.w,
                  color: Colours.cF0,
                ),
                GestureDetector(
                  onTap: () async {
                    _checkUpdates();
                  },
                  child: Container(
                    color: Colors.white,
                    margin: EdgeInsets.only(left: 15.w),
                    height: 45.w,
                    alignment: Alignment.centerLeft,
                    child: Text('查看更新 >',
                        style: TextStyle(fontSize: 14.w, color: Colours.c3)),
                  ),
                ),
                Container(
                  margin: EdgeInsets.symmetric(horizontal: 10.w),
                  height: 0.5.w,
                  color: Colours.cF0,
                ),
                GestureDetector(
                  onTap: () {
                    context.pushNamed(Routes.version);
                  },
                  child: Container(
                    color: Colors.white,
                    margin: EdgeInsets.only(left: 15.w),
                    height: 45.w,
                    alignment: Alignment.centerLeft,
                    child: Text('版本介绍 >',
                        style: TextStyle(fontSize: 14.w, color: Colours.c3)),
                  ),
                )
              ],
            ),
          ),
          GestureDetector(
            onTap: () async {
              showDialog(
                context: context,
                builder: (BuildContext context) {
                  return AlertDialog(
                    shape: RoundedRectangleBorder(
                      borderRadius: BorderRadius.circular(8.0.w),
                    ),
                    contentPadding: EdgeInsets.zero,
                    // 移除内容部分的内边距
                    content: Wrap(
                      children: [
                        Container(
                          margin:
                          EdgeInsets.only(top: 44.w, bottom: 29.w),
                          // 调整上下间距
                          child: Center(
                            child: Text(
                              '确定退出登录吗？',
                              style: TextStyle(
                                fontSize: 15.w,
                                fontWeight: Fonts.medium,
                                color: Colours.c3,
                              ),
                            ),
                          ),
                        ),
                        Container(
                          height: 1.w, // 设置分割线的高度
                          width: double.infinity, // 设置分割线的宽度
                          color: Colours.cLine, // 设置分割线的颜色
                        ),
                      ],
                    ),
                    // 去除操作按钮区域的内边距
                    actionsPadding: EdgeInsets.zero,
                    actions: <Widget>[
                      Row(
                        mainAxisAlignment: MainAxisAlignment.spaceEvenly,
                        children: [
                          GestureDetector(
                            onTap: () => Navigator.of(context).pop(),
                            child: Container(
                              width: 105.w,
                              color: Colours.cFF,
                              alignment: Alignment.center,
                              child: const Text(
                                '取消',
                                style: TextStyle(
                                  fontSize: 15,
                                  fontWeight: Fonts.medium,
                                  color: Colours.c6,
                                ),
                              ),
                            ),
                          ),
                          Container(
                            height: 39.5.w, // 设置分割线的高度
                            width: 1, // 设置分割线的宽度
                            color: Colours.cLine, // 设置分割线的颜色
                          ),
                          GestureDetector(
                            onTap: () async {
                              final result = await AccountAPI.logout();
                              if (result) {
                                // Toast.show('退出成功');
                                CustomToast.loading();
                                await UserStore.to.logout();
                                CustomToast.dismiss();
                                if (context.mounted) {
                                  context.goNamed(Routes.splash);
                                }
                              }
                            },
                            child: Container(
                              width: 105.w,
                              color: Colours.cFF,
                              alignment: Alignment.center,
                              child: const Text(
                                '确定',
                                style: TextStyle(
                                  fontSize: 15,
                                  fontWeight: Fonts.boldSemi,
                                  color: Colours.cAB1941,
                                ),
                              ),
                            ),
                          ),
                        ],
                      ),
                    ],
                  );
                },
              );
            },
            // onTap: () async {
            //   final result = await AccountAPI.logout();
            //   if (result) {
            //     // Toast.show('退出成功');
            //     CustomToast.loading();
            //     await UserStore.to.logout();
            //     CustomToast.dismiss();
            //     if (context.mounted) {
            //       context.goNamed(Routes.splash);
            //     }
            //   }
            // },
            child: Container(
              height: 42.w,
              width: double.infinity,
              alignment: Alignment.center,
              decoration: BoxDecoration(
                borderRadius: BorderRadius.circular(8.w),
                color: Colors.white,
                boxShadow: [
                  BoxShadow(
                    color: const Color(0xFFC7C7C7).withOpacity(0.5),
                    offset: Offset(3.w, 0),
                    blurRadius: 10.w,
                    spreadRadius: 0.w,
                  ),
                ],
              ),
              margin: EdgeInsets.symmetric(horizontal: AppTheme.margin),
              child: Text(
                '退出登录',
                style: TextStyle(fontSize: 14.w, color: Colours.c3),
              ),
            ),
          )
        ],
      ),
    );
  }

  void clearCache() {
    ClearCache().clearApplicationCache();
    Toast.show('清除完成');
  }

  void _checkUpdates() async {
    UModel model = await MineAPI.update();
    _getModel = model;
    final packageInfo = await PackageInfo.fromPlatform();
    int getVersion = int.parse(model.version!.replaceAll('.', ''));
    int localVersion = int.parse(packageInfo.version.replaceAll('.', ''));
    if (localVersion < getVersion) {
      _showUpdateDialog(false);
    }
  }

  ///Flutter侧处理升级对话框
  ///[forcedUpgrade] 是否强制升级
  /*_showUpdateDialog(bool forcedUpgrade) {
    showDialog(
      context: context,
      barrierDismissible: !forcedUpgrade,
      builder: (BuildContext context) {
        return WillPopScope(
          onWillPop: () => Future.value(!forcedUpgrade),
          child: AlertDialog(
            shape: RoundedRectangleBorder(
              borderRadius: BorderRadius.circular(8.0.w),
            ),
            // title: Text('发现新版本',style: TextStyle(fontSize: 16.w,fontWeight: Fonts.medium,color: Colours.c3),),
            // content:  Text(_getModel.remarks??'',style: TextStyle(fontSize: 13.w,fontWeight: Fonts.medium,color: Colours.c3),),
            actions: <Widget>[
              Row(
                mainAxisAlignment: MainAxisAlignment.center,
                children: [
                  Column(
                    mainAxisAlignment: MainAxisAlignment.start,
                    children: [
                      SizedBox(
                        height: 25.5.w,
                      ),
                      SizedBox(
                        height: 92.w,
                        width: 92.w,
                        child: Image.asset('assets/images/app_update.png'),
                      ),
                      SizedBox(
                        height: 13.w,
                      ),
                      Text(
                        "版本更新",
                        style: TextStyle(
                            fontSize: 14.w,
                            color: Colours.c3,
                            fontWeight: Fonts.medium),
                      ),
                      Padding(
                        padding: EdgeInsets.only(top: 5.5.w),
                        child: Text(
                          '发现新版本V${_getModel.version}',
                          style: TextStyle(
                              fontSize: 10.w,
                              color: Colours.c9,
                              fontWeight: Fonts.medium),
                        ),
                      ),
                      SizedBox(
                        height: 22.w,
                      ),

                      Row(
                        mainAxisAlignment: MainAxisAlignment.spaceBetween,
                        children: [
                          if (!forcedUpgrade)
                            TextButton(
                              child: const Text(
                                '稍后再说',
                                style: TextStyle(
                                    color: Colours.c6,
                                    fontSize: 12,
                                    fontWeight: Fonts.medium),
                              ),
                              onPressed: () => Navigator.of(context).pop(),
                            ),

                          TextButton(
                            child: const Text(
                              '立即更新',
                              style: TextStyle(
                                  color: Colours.cAB1941,
                                  fontSize: 12,
                                  fontWeight: Fonts.medium),
                            ),
                            onPressed: () {
                              _appUpdate();
                              if (!forcedUpgrade) {
                                Navigator.of(context).pop();
                              }
                            },
                          ),
                        ],
                      ),
                    ],
                  ),
                ],
              ),
            ],
          ),
        );
      },
    );
  }*/
  _showUpdateDialog(bool forcedUpgrade) {
    showDialog(
      context: context,
      barrierDismissible: !forcedUpgrade,
      builder: (BuildContext context) {
        return WillPopScope(
          onWillPop: () => Future.value(!forcedUpgrade),
          child: AlertDialog(
            insetPadding: EdgeInsets.zero, // 设置水平边距
            shape: RoundedRectangleBorder(
              borderRadius: BorderRadius.circular(8.0.w),
            ),
            // 去除操作按钮区域的内边距
            actionsPadding: EdgeInsets.zero,
            actions: <Widget>[
              Row(
                mainAxisAlignment: MainAxisAlignment.center,
                children: [
                  Column(
                    mainAxisAlignment: MainAxisAlignment.start,
                    children: [
                      SizedBox(
                        height: 25.5.w,
                      ),
                      SizedBox(
                        height: 92.w,
                        width: 92.w,
                        child: Image.asset('assets/images/app_update.png'),
                      ),
                      SizedBox(
                        height: 13.w,
                      ),
                      Text(
                        "版本更新",
                        style: TextStyle(
                            fontSize: 14.w,
                            color: Colours.c3,
                            fontWeight: Fonts.medium),
                      ),
                      Padding(
                        padding: EdgeInsets.only(top: 5.5.w),
                        child: Text(
                          '发现新版本V${_getModel.version}',
                          style: TextStyle(
                              fontSize: 10.w,
                              color: Colours.c9,
                              fontWeight: Fonts.medium),
                        ),
                      ),
                      SizedBox(
                        height: 22.w,
                      ),
                      Container(
                        height: 1, // 设置分割线的高度
                        width: 216.5.w, // 设置分割线的宽度
                        color: Colours.cLine, // 设置分割线的颜色
                      ),
                      Row(
                        mainAxisAlignment: MainAxisAlignment.spaceBetween,
                        children: [
                          if (!forcedUpgrade)
                            Padding(padding: EdgeInsets.only(right: 28.w),
                            child:  GestureDetector(
                              child:
                              Container(
                                width: 85.w,
                                color: Colours.cFF,
                                alignment: Alignment.center,
                                child:  const Text(
                                  '稍后再说',
                                  style: TextStyle(
                                      color: Colours.c6,
                                      fontSize: 15,
                                      fontWeight: Fonts.medium),
                                ),
                              ),
                              onTap: () => Navigator.of(context).pop(),
                            ),),

                          Container(
                            height: 39.5.w, // 设置分割线的高度
                            width: 1, // 设置分割线的宽度
                            color: Colours.cLine, // 设置分割线的颜色
                          ),
                          Padding(padding: EdgeInsets.only(left: 28.w),
                            child:   GestureDetector(
                              child: Container(
                                width: 85.w,
                                color: Colours.cFF,
                                alignment: Alignment.center,
                                child:  const Text(
                                  '立即更新',
                                  style: TextStyle(
                                      color: Colours.cAB1941,
                                      fontSize: 15,
                                      fontWeight: Fonts.boldSemi),
                                ),
                              ),
                              onTap: () {
                                _appUpdate();
                                if (!forcedUpgrade) {
                                  Navigator.of(context).pop();
                                }
                              },
                            ),
                          ),

                        ],
                      ),
                    ],
                  ),
                ],
              ),
            ],
          ),
        );
      },
    );
  }



  /// TODO: 苹果市场app地址
  _appUpdate() {
    UpdateModel model = UpdateModel(
      _getModel.url!,
      "zijing.apk",
      "ic_launcher",
      'https://itunes.apple.com/cn/app/抖音/id1142110895',
    );
    AzhonAppUpdate.update(model).then((value) => debugPrint('$value'));
  }
}
