part of user_order_evaluate;

/// 订单评价
class UserOrderEvaluateController extends GetxController {
  late OrderInfoModel orderInfoModel = OrderInfoModel();
  String orderNum;

  UserOrderEvaluateController(this.orderNum); // 已完成订单
  TextEditingController commentsInput = TextEditingController();
  late List<TextEditingController> _commentsControllers;
  late List<num?> ratings;
  late List<FocusNode?> focusNodes;
  // final FocusNode _focusNode = FocusNode();

  // 按钮是否可用
  bool _enable = false;

  bool get enable => _enable;

  @override
  void onReady() {
    getOrderInfo();
    super.onReady();
  }

  /// 获取订单信息
  Future<void> getOrderInfo() async {
    orderInfoModel = await MineAPI.getOrderInfo(orderNum: orderNum);
    _commentsControllers = List.generate(
      orderInfoModel.bookList!.length,
      (index) => TextEditingController(
          text: orderInfoModel.bookList![index].comments.toString()),
    );
    ratings = List.generate(
      orderInfoModel.bookList!.length,
      (index) => orderInfoModel.bookList![index].rating,
    );
    focusNodes = List.generate(
      orderInfoModel.bookList!.length,
          (index) => FocusNode(),
    );
    update();
  }

  /// 上传评价
  Future<bool> UpOrderEvaluate(String evaluate) async {
    final result = await MineAPI.UpOrderEvaluate(evaluate: evaluate);
    if (result) {
      Toast.show('评价成功');
      _enable = false;
      getOrderInfo();
    }
    return result;
  }

  /// 判断图书是否已评价，评价返回false，未评价返回true
  bool judgeComments(BookListModel bookListModel) {
    // 无图书
    if (bookListModel.rating == 0) {
      return true;
    }
    return false;
  }

  void setCanClick({num double = 0}) {
    if (double > 0) {
      _enable = true;
    } else {
      _enable = false;
    }
    update();
  }

  void updateText(String text) {
    commentsInput = TextEditingController(text: text);
    // update();
  }

  @override
  void onClose() {
    commentsInput.dispose();
    for(TextEditingController controller in _commentsControllers){
      controller.dispose();
    }
    for(int i=0;i<focusNodes.length;i++){
      focusNodes[i]!.dispose();
    }
    super.onClose();
  }
}
