part of routes;

abstract class Routes {
  static final RouteObserver<Route> observer = RouteObservers();
  static List<String> history = [];

  static const splash = 'splash';
  static const main = 'main';
  static const ad = 'ad';
  static const adDetail = 'ad_detail';


  static const web = 'read_web';
  static const answer = 'answer';
  static const readInfo = 'read_info';

  // 支付界面
  static const bookPay = 'book_pay';
  // 用户协议 和 隐私政策
  static const terms = 'terms';
  // 搜索
  static const search = 'search';


  /// 登录模块
  // 登录
  static const login = 'login';
  // 忘记密码
  static const forgetPwd = 'forget_pwd';
  // 重置密码
  static const resetPwd = 'reset_pwd';


  /// 课程模块
  // 详情
  static const bookDetail = 'book_detail';
  // 评分及书评
  static const bookScore = 'book_score';
  // 学习报告
  static const studyReport = 'study_report';


  /// 图书馆模块
  // 百科
  static const baiKe = 'bai_ke';
  // 字典
  static const baiDict = 'bai_dict';
  // 外部链接
  static const link = 'link';

  /// 书架模块
  static const creditPoints = 'credit_points';
  static const shop = 'shop';
  static const payCoupon = 'pay_coupon';



  /// 我的模块
  // 个人信息
  static const userInfo = 'user_info';
  // 修改昵称
  static const nike = 'nike';
  // 性别
  static const gender = 'gender';
  // 设置
  static const set = 'set';
  // 版本
  static const version = 'version';
  // 版本介绍
  static const versionDes = 'version_des';
  // 我的收藏
  static const collect = 'collect';
  // 紫金币记录
  static const coin = 'coin';
  // 积分记录
  static const point = 'point';
  // 消息
  static const msgs = 'msgs';
  // 关于
  static const about = 'user_about';
  // 最近学习
  static const studyHistory = 'study_history';
  // 我的收藏
  static const love = 'love';
  // 笔记
  static const note = 'note';
  // 笔记详情
  static const noteDes = 'note_des';
  // 编辑笔记
  static const editNote = 'edit_note';
  // 错题
  static const wrong = 'wrong';
  // 错题详情
  static const wrongDes = 'wrong_des';
  // 讨论
  static const discuss = 'discuss';
  // 讨论详情
  static const discussDes = 'discuss_des';
  // 优惠券
  static const coupon = 'coupon';
  // 账号安全
  static const security = 'security';
  // 修改手机号
  static const changePhone = 'change_change';
  // 修改密码
  static const changePwd = 'change_pwd';
  // 意见反馈
  static const feedback = 'feedback';
  // 订单评价
  static const orderEvaluate= 'order_evaluate';
  // 帮助中心
  static const helpCenter= 'help_center';
  // 帮助中心内容
  static const helpCenterContent = 'help_center_content';
  // 订单列表
  static const order= 'order';
  // 已完成订单
  static const orderCompleted= 'order_completed';
  // 图书待付款订单
  static const orderAwaiting= 'order_awaiting';
  // 图书取消订单
  static const orderCancel= 'order_cancel';
  // 紫荆币待付款订单
  static const orderCoinAwaiting= 'order_coin_awaiting';
  // 紫荆币已取消订单
  static const orderCoinCancel= 'order_coin_cancel';
  // 紫荆币已完成订单
  static const orderCoinCompleted= 'order_coin_completed';
  // 已退款订单
  static const orderRefunded= 'order_refunded';
  // 搜索订单
  static const orderSearch= 'order_search';
  // 图片预览
  static const imageView = 'image_view';




  static final GoRouter config = GoRouter(
      initialLocation: '/$splash',
      // initialLocation: '/',
      observers: [observer],
      refreshListenable:UserStore.to.needLogin,
      redirect: (context, state) {
        final currentRoute = state.matchedLocation;
        final loginRoute = state.namedLocation(login);
        final mainRoute = state.namedLocation(main);
        if (currentRoute.contains(mainRoute)) return null;
        if(currentRoute.contains(loginRoute)) return null;
        if(!UserStore.to.isLogin) return loginRoute;
        return null;
      },
      routes: [
        GoRoute(
            path: '/$splash',
            name: splash,
            pageBuilder: (context, state) =>CupertinoPage(
                name: state.uri.toString(),
                key: state.pageKey,
                child: const SplashPage(),
            ),
        ),
        GoRoute(
            path: '/',
            name: main,
            pageBuilder: (context, state) =>CupertinoPage(
                name: state.uri.toString(),
                key: state.pageKey,
                child: const MainPage()
            )
        ),
        GoRoute(
            path: '/$ad',
            name: ad,
            pageBuilder: (context, state) =>CupertinoPage(
                name: state.uri.toString(),
                key: state.pageKey,
                child: AdPage(ads: state.extra as List<AdModel>,)
            )
        ),
        /// 登录模块
        GoRoute(
            path: '/$login',
            name: login,
            pageBuilder: (context, state) =>CupertinoPage(
                name: state.uri.toString(),
                key: state.pageKey,
                child: const LoginPage()
            )
        ),
        GoRoute(
            path: '/$forgetPwd',
            name: forgetPwd,
            pageBuilder: (context, state) =>CupertinoPage(
                name: state.uri.toString(),
                key: state.pageKey,
                child: const ForgetPwdPage()
            )
        ),
        GoRoute(
            path: '/$resetPwd',
            name: resetPwd,
            pageBuilder: (context, state) =>CupertinoPage(
                name: state.uri.toString(),
                key: state.pageKey,
                child: ResetPwdPage(
                  phone: state.uri.queryParameters['phone'].toString(),
                  code: state.uri.queryParameters['code'].toString(),
                )
            )
        ),
        GoRoute(
            path: '/$web',
            name: web,
            pageBuilder: (context, state) =>CupertinoPage(
                name: state.uri.toString(),
                key: state.pageKey,
                child: ReadPage(
                  bookId: state.uri.queryParameters['book_id'].toString(),
                  chapterId: state.uri.queryParameters['chapter_id'].toString(),
                  chapterName: state.uri.queryParameters['chapter_name'].toString(),
                  bookDetailModel: state.extra as BookDetailModel,
                  noteId: state.uri.queryParameters['note_id'].toString(),
                )
            )
        ),
        GoRoute(
            path: '/$about',
            name: about,
            pageBuilder: (context, state) =>CupertinoPage(
                name: state.uri.toString(),
                key: state.pageKey,
                child: const AboutPage()
            )
        ),
        GoRoute(
            path: '/$bookPay',
            name: bookPay,
            pageBuilder: (context, state) =>CupertinoPage(
                name: state.uri.toString(),
                key: state.pageKey,
                child: BookPayPage(buy: state.extra as List<CourseModel>,)
            )
        ),
        GoRoute(
            path: '/$terms',
            name: terms,
            pageBuilder: (context, state) =>CupertinoPage(
                name: state.uri.toString(),
                key: state.pageKey,
                child: TermsPage(
                  url: state.uri.queryParameters['url'].toString(),
                  title: state.uri.queryParameters['title'].toString(),
                )
            )
        ),
        GoRoute(
            path: '/$msgs',
            name: msgs,
            pageBuilder: (context, state) =>CupertinoPage(
                name: state.uri.toString(),
                key: state.pageKey,
                child: const MsgPage()
            )
        ),
        GoRoute(
            path: '/$userInfo',
            name: userInfo,
            pageBuilder: (context, state) =>CupertinoPage(
                name: state.uri.toString(),
                key: state.pageKey,
                child: UserInfoPage(userInfo: state.extra as UserInfoModel,)
            )
        ),
        GoRoute(
            path: '/$nike',
            name: nike,
            pageBuilder: (context, state) =>CupertinoPage(
                name: state.uri.toString(),
                key: state.pageKey,
                child: UserNickPage(userInfo: state.extra as UserInfoModel,)
            )
        ),
        GoRoute(
            path: '/$coin',
            name: coin,
            pageBuilder: (context, state) =>CupertinoPage(
                name: state.uri.toString(),
                key: state.pageKey,
                child: const UserCoinPage()
            )
        ),
        GoRoute(
            path: '/$bookDetail',
            name: bookDetail,
            pageBuilder: (context, state) =>CupertinoPage(
                name: state.uri.toString(),
                key: state.pageKey,
                child: BookDetailPage(
                  bookId: state.uri.queryParameters['book_id'].toString(),
                )
            ),
            redirect: (context, state) => _RouteRedirect.auth(),
        ),
        GoRoute(
            path: '/$bookScore',
            name: bookScore,
            pageBuilder: (context, state) =>CupertinoPage(
                name: state.uri.toString(),
                key: state.pageKey,
                child: BookScorePage(
                  bookId: state.uri.queryParameters['book_id'].toString(),
                )
            )
        ),
        GoRoute(
            path: '/$studyReport',
            name: studyReport,
            pageBuilder: (context, state) =>CupertinoPage(
                name: state.uri.toString(),
                key: state.pageKey,
                child: StudyReportPage(
                  bookId: state.uri.queryParameters['book_id'].toString(),
                )
            )
        ),
        GoRoute(
            path: '/$creditPoints',
            name: creditPoints,
            pageBuilder: (context, state) =>CupertinoPage(
                name: state.uri.toString(),
                key: state.pageKey,
                child: const CreditPointsPage()
            )
        ),
        GoRoute(
            path: '/$payCoupon',
            name: payCoupon,
            pageBuilder: (context, state) =>CupertinoPage(
                name: state.uri.toString(),
                key: state.pageKey,
                child: PayCouponPage(
                  payController: state.extra as BookPayController,
                )
            )
        ),
        GoRoute(
            path: '/$search',
            name: search,
            pageBuilder: (context, state) =>CupertinoPage(
                name: state.uri.toString(),
                key: state.pageKey,
                child: const SearchPage()
            )
        ),
        GoRoute(
            path: '/$studyHistory',
            name: studyHistory,
            pageBuilder: (context, state) =>CupertinoPage(
                name: state.uri.toString(),
                key: state.pageKey,
                child: const StudyHistoryPage()
            )
        ),
        GoRoute(
            path: '/$love',
            name: love,
            pageBuilder: (context, state) =>CupertinoPage(
                name: state.uri.toString(),
                key: state.pageKey,
                child: const UserLovePage()
            )
        ),
        GoRoute(
            path: '/$shop',
            name: shop,
            pageBuilder: (context, state) =>CupertinoPage(
                name: state.uri.toString(),
                key: state.pageKey,
                child: const BookShopPage()
            )
        ),
        GoRoute(
            path: '/$note',
            name: note,
            pageBuilder: (context, state) =>CupertinoPage(
                name: state.uri.toString(),
                key: state.pageKey,
                child: const UserNotePage()
            )
        ),
        GoRoute(
            path: '/$wrong',
            name: wrong,
            pageBuilder: (context, state) =>CupertinoPage(
                name: state.uri.toString(),
                key: state.pageKey,
                child: const UserWrongPage()
            )
        ),
        GoRoute(
            path: '/$wrongDes',
            name: wrongDes,
            pageBuilder: (context, state) =>CupertinoPage(
                name: state.uri.toString(),
                key: state.pageKey,
                child: UserWrongDesPage(
                    model: state.extra as CourseModel
                )
            )
        ),
        GoRoute(
            path: '/$point',
            name: point,
            pageBuilder: (context, state) =>CupertinoPage(
                name: state.uri.toString(),
                key: state.pageKey,
                child: const UserPointPage()
            )
        ),
        GoRoute(
            path: '/$discuss',
            name: discuss,
            pageBuilder: (context, state) =>CupertinoPage(
                name: state.uri.toString(),
                key: state.pageKey,
                child: const UserDiscussPage()
            )
        ),
        GoRoute(
            path: '/$coupon',
            name: coupon,
            pageBuilder: (context, state) =>CupertinoPage(
                name: state.uri.toString(),
                key: state.pageKey,
                child: const UserCouponPage()
            )
        ),
        GoRoute(
            path: '/$set',
            name: set,
            pageBuilder: (context, state) =>CupertinoPage(
                name: state.uri.toString(),
                key: state.pageKey,
                child: const UserSetPage()
            )
        ),
        GoRoute(
            path: '/$version',
            name: version,
            pageBuilder: (context, state) =>CupertinoPage(
                name: state.uri.toString(),
                key: state.pageKey,
                child: const VersionPage()
            )
        ),
        GoRoute(
            path: '/$versionDes',
            name: versionDes,
            pageBuilder: (context, state) =>CupertinoPage(
                name: state.uri.toString(),
                key: state.pageKey,
                child: VersionDesPage(model: state.extra as VersionModel,)
            )
        ),
        GoRoute(
            path: '/$security',
            name: security,
            pageBuilder: (context, state) =>CupertinoPage(
                name: state.uri.toString(),
                key: state.pageKey,
                child: UserSecurityPage(model: state.extra as UserInfoModel,)
            )
        ),
        GoRoute(
            path: '/$changePhone',
            name: changePhone,
            pageBuilder: (context, state) =>CupertinoPage(
                name: state.uri.toString(),
                key: state.pageKey,
                child: const ChangePhonePage()
            )
        ),
        GoRoute(
            path: '/$changePwd',
            name: changePwd,
            pageBuilder: (context, state) =>CupertinoPage(
                name: state.uri.toString(),
                key: state.pageKey,
                child: ChangePwdPage(
                  userInfo: state.extra as UserInfoModel,
                  type: state.uri.queryParameters['type'].toString(),
                )
            )
        ),
        GoRoute(
            path: '/$feedback',
            name: feedback,
            pageBuilder: (context, state) =>CupertinoPage(
                name: state.uri.toString(),
                key: state.pageKey,
                child: const UserFeedbackPage()
            )
        ),
        GoRoute(
            path: '/$noteDes',
            name: noteDes,
            pageBuilder: (context, state) =>CupertinoPage(
                name: state.uri.toString(),
                key: state.pageKey,
                child: UserNotesDesPage(model: state.extra as CourseModel,)
            )
        ),
        GoRoute(
            path: '/$gender',
            name: gender,
            pageBuilder: (context, state) =>CupertinoPage(
                name: state.uri.toString(),
                key: state.pageKey,
                child: UserGenderPage(userInfo: state.extra as UserInfoModel,)
            )
        ),
        GoRoute(
            path: '/$discussDes',
            name: discussDes,
            pageBuilder: (context, state) =>CupertinoPage(
                name: state.uri.toString(),
                key: state.pageKey,
                child: UserDiscussDesPage(model: state.extra as CourseModel,)
            )
        ),

        GoRoute(
            path: '/$orderEvaluate',
            name: orderEvaluate,
            pageBuilder: (context, state) =>CupertinoPage(
                name: state.uri.toString(),
                key: state.pageKey,
                child:  UserOrderEvaluatePage(orderNum:state.uri.queryParameters['orderNum'].toString(),orderInfoModel: state.extra as OrderInfoModel,)
            )
        ),
        GoRoute( // 帮助中心
            path: '/$helpCenter',
            name: helpCenter,
            pageBuilder: (context, state) =>CupertinoPage(
                name: state.uri.toString(),
                key: state.pageKey,
                child: const HelpCenterPage()
            )
        ),
        GoRoute( // 帮助中心内容
            path: '/$helpCenterContent',
            name: helpCenterContent,
            pageBuilder: (context, state) =>CupertinoPage(
                name: state.uri.toString(),
                key: state.pageKey,
                child: HelpCenterContentPage(
                    id: state.uri.queryParameters['id'].toString(),
                    title: state.uri.queryParameters['title'].toString(),
                )
            )
        ),
        GoRoute( // 已完成订单
            path: '/$order',
            name: order,
            pageBuilder: (context, state) =>CupertinoPage(
                name: state.uri.toString(),
                key: state.pageKey,
                child: const UserOrderPage()
            )
        ),
        GoRoute( // 已完成订单
            path: '/$orderCompleted',
            name: orderCompleted,
            pageBuilder: (context, state) =>CupertinoPage(
                name: state.uri.toString(),
                key: state.pageKey,
                child: UserOrderCompletedPage(orderNum: state.uri.queryParameters['orderNum'].toString())
            )
        ),
        GoRoute( // 图书待付款订单
            path: '/$orderAwaiting',
            name: orderAwaiting,
            pageBuilder: (context, state) =>CupertinoPage(
                name: state.uri.toString(),
                key: state.pageKey,
                child: UserOrderAwaitingPage(orderNum: state.uri.queryParameters['orderNum'].toString())
            )
        ),
        GoRoute( // 图书取消订单
            path: '/$orderCancel',
            name: orderCancel,
            pageBuilder: (context, state) =>CupertinoPage(
                name: state.uri.toString(),
                key: state.pageKey,
                child: UserOrderCancelDetailPage(orderNum: state.uri.queryParameters['orderNum'].toString())
            )
        ),
        GoRoute( // 紫荆币待付款订单
            path: '/$orderCoinAwaiting',
            name: orderCoinAwaiting,
            pageBuilder: (context, state) =>CupertinoPage(
                name: state.uri.toString(),
                key: state.pageKey,
                child: UserOrderCoinAwaitingPage(orderNum: state.uri.queryParameters['orderNum'].toString())
            )
        ),
        GoRoute( // 紫荆币已取消订单
            path: '/$orderCoinCancel',
            name: orderCoinCancel,
            pageBuilder: (context, state) =>CupertinoPage(
                name: state.uri.toString(),
                key: state.pageKey,
                child: UserOrderCoinCancelPage(orderNum: state.uri.queryParameters['orderNum'].toString())
            )
        ),
        GoRoute( // 紫荆币已完成订单
            path: '/$orderCoinCompleted',
            name: orderCoinCompleted,
            pageBuilder: (context, state) =>CupertinoPage(
                name: state.uri.toString(),
                key: state.pageKey,
                child: UserOrderCoinCompletedPage(orderNum: state.uri.queryParameters['orderNum'].toString())
            )
        ),
        GoRoute( // 已退款订单
            path: '/$orderRefunded',
            name: orderRefunded,
            pageBuilder: (context, state) =>CupertinoPage(
                name: state.uri.toString(),
                key: state.pageKey,
                child: UserOrderRefundedPage(orderNum: state.uri.queryParameters['orderNum'].toString())
            )
        ),
        GoRoute( // 百科
            path: '/$baiKe',
            name: baiKe,
            pageBuilder: (context, state) =>CupertinoPage(
                name: state.uri.toString(),
                key: state.pageKey,
                child: BaiKePage(
                  keyword: state.uri.queryParameters['keyword'].toString(),
                )
            )
        ),
        GoRoute(
            path: '/$editNote',
            name: editNote,
            pageBuilder: (context, state) =>CupertinoPage(
                name: state.uri.toString(),
                key: state.pageKey,
                child: UserEditNotePage(model: state.extra as NoteModel,bookId: state.uri.queryParameters['book_id'].toString(),)
            )
        ),
        GoRoute( // 订单搜索
            path: '/$orderSearch',
            name: orderSearch,
            pageBuilder: (context, state) =>CupertinoPage(
                name: state.uri.toString(),
                key: state.pageKey,
                child: const OrderSearchPage(),
            )
        ),
        GoRoute( // 订单搜索
            path: '/$adDetail',
            name: adDetail,
            pageBuilder: (context, state) =>CupertinoPage(
              name: state.uri.toString(),
              key: state.pageKey,
              child: AdDetailPage(adModel: state.extra as AdModel,),
            )
        ),
        GoRoute( // 字典
            path: '/$baiDict',
            name: baiDict,
            pageBuilder: (context, state) =>CupertinoPage(
                name: state.uri.toString(),
                key: state.pageKey,
                child: BaiDictPage(
                  keyword: state.uri.queryParameters['keyword'].toString(),
                )
            )
        ),
        GoRoute( // 外部链接
            path: '/$link',
            name: link,
            pageBuilder: (context, state) =>CupertinoPage(
                name: state.uri.toString(),
                key: state.pageKey,
                child: LinkPage(
                  url: state.uri.queryParameters['url'].toString(),
                )
            )
        ),
        GoRoute( // 知识测评
            path: '/$answer',
            name: answer,
            pageBuilder: (context, state) =>CupertinoPage(
                name: state.uri.toString(),
                key: state.pageKey,
                child: AnswerPage(
                  params: state.uri.queryParameters,
                )
            )
        ),
        GoRoute( // 画廊 扩展阅读
            path: '/$readInfo',
            name: readInfo,
            pageBuilder: (context, state) =>CupertinoPage(
                name: state.uri.toString(),
                key: state.pageKey,
                child: ReadInfoPage(
                  params: state.uri.queryParameters,
                )
            )
        ),
        GoRoute( // 图片预览
            path: '/$imageView',
            name: imageView,
            pageBuilder: (context, state) =>BottomToTopTransitionPage(
                name: state.uri.toString(),
                key: state.pageKey,
                child: ImageViewPage(
                  images: state.extra as List<String>,
                  currentIndex: int.parse(state.uri.queryParameters['index'].toString()),

                )
            )
        ),
      ]
  );

}

abstract class _RouteRedirect {
  static String? auth() {
    if (UserStore.to.isLogin) return null;
    return '/${Routes.login}';
  }
}