part of help_center;

class HelpCenterController extends GetxController {
  final EasyRefreshController refreshController = EasyRefreshController(
    controlFinishLoad: true,
    controlFinishRefresh: true,
  );

  final int _limit = 10;
  int _page = 1;
  bool _noMore = false;
  List<HelpCenterModel> helpCenters = [];


  @override
  void onClose() {
    refreshController.dispose();
    super.onClose();
  }

  /// 获取课程内图书列表
  Future<void> _gethelpCenters([bool isRefresh = false]) async {
    if (isRefresh) _page = 1;
    // 网路请求
    final result = await MineAPI.helpCenters(
        page: _page,
        limit: _limit
    );
    // 如果是刷新 清理数据
    if (isRefresh) helpCenters.clear();
    helpCenters.addAll(result);
    _page ++;
    _noMore = result.length < _limit;
    update();

  }

  void onRefresh() async {
    try {
      await _gethelpCenters(true);
      refreshController.finishRefresh(IndicatorResult.success);
      refreshController.resetFooter();
    } catch (error) {
      refreshController.finishRefresh(IndicatorResult.fail);
    }
  }

  void onLoading() async {
    if (_noMore) {
      refreshController.finishLoad(IndicatorResult.noMore);
      return;
    }
    try {
      await _gethelpCenters();
      refreshController.finishLoad();
    } catch (error) {
      refreshController.finishLoad(IndicatorResult.fail);
    }
  }

  List<HelpCenterModel> test(){
    return [
      HelpCenterModel(id: 1,helpTitle: '账号注册'),
      HelpCenterModel(id: 2,helpTitle: '如何进行充值'),
      HelpCenterModel(id: 3,helpTitle: '如何对内容进行划线'),
    ];
  }

}