part of read_info;


class ReadInfoPage extends StatefulWidget {
  final Map<String,String> params;
  const ReadInfoPage({
    Key? key,
    required this.params
  }) : super(key: key);

  @override
  State<ReadInfoPage> createState() => _ReadInfoPageState();
}

class _ReadInfoPageState extends State<ReadInfoPage> {
  @override
  Widget build(BuildContext context) {
    return Scaffold(
        appBar: AppBar(
          title: Text('${widget.params['title']}'),
        ),
        body: InAppWebView(
          initialUrlRequest: URLRequest(
              url: WebUri.uri(Uri.parse(kReadInfo))
          ),
          onLoadStop: (controller, url) {
            String jsonStr = jsonEncode(widget.params);
            controller.evaluateJavascript(source: 'callbackInFlutterComponent($jsonStr)');
          },
          onConsoleMessage: (controller, consoleMessage) {
            // 接收从 WebView 发送的消息
            Console.log("画廊扩展阅读-------Received message from WebView-----------------------------: ${consoleMessage.message}");
          },
        )
    );
  }
}
