part of user_coin;

class BuildCell extends StatelessWidget {
  final RecordModel model;
  const BuildCell({
    Key? key,
    required this.model
  }) : super(key: key);

  @override
  Widget build(BuildContext context) {
    return Column(
      crossAxisAlignment: CrossAxisAlignment.start,
      children: [
        Container(
          // color: Colors.green,
          padding: EdgeInsets.symmetric(horizontal: 10.w),
          child: Row(
            mainAxisAlignment: MainAxisAlignment.spaceBetween,
            children: [
              Container(
                child: Row(
                  children: [
                    Container(
                      width: 27.w,
                      height: 27.w,
                      decoration: BoxDecoration(
                        borderRadius: BorderRadius.circular(13.5.w),
                        color: Colors.cyan,
                      ),
                    ),
                    Gaps.hGaps10,
                    Column(
                      crossAxisAlignment: CrossAxisAlignment.start,
                      children: [
                        Gaps.vGaps15,
                        Text(model.remarks??'',style: TextStyle(color: Colours.c3,fontSize: 14.w,height: 1.6,fontWeight: Fonts.medium),),
                        Text(model.createTime??'',style: TextStyle(color: Colours.c9,fontSize: 10.w,height: 1.6,)),
                        Gaps.vGaps15,
                      ],
                    )
                  ],
                ),
              ),
              Text(model.options == 1?'+${model.numbers}':'-${model.numbers}',style: TextStyle(fontSize: 17.w,fontWeight: Fonts.medium,color: model.options == 1?AppTheme.primary:Colours.c3),)
            ],
          ),
        ),
        Container(color: Colours.cLine,margin: EdgeInsets.symmetric(horizontal: 15.w),height: 1,),
      ],
    );
  }
}

