part of user_notes_des;

class BuildNote extends StatelessWidget {
  final NoteModel model;
  final void Function()? onTapDel;
  final void Function()? onTapEdit;
  final void Function(MediaModel mediaModel)? onTapAudio;
  const BuildNote({
    Key? key,
    required this.model,
    this.onTapDel,
    this.onTapEdit,
    this.onTapAudio
  }) : super(key: key);

  @override
  Widget build(BuildContext context) {
    return Container(
      margin: EdgeInsets.only(left: 10.w,right: 10.w,top: 10.w),
      // padding: EdgeInsets.all(10.w),
      decoration: BoxDecoration(
        borderRadius: BorderRadius.circular(4.w),
        color: Colors.white,
        boxShadow: [
          BoxShadow(
            color: const Color(0xFFC7C7C7).withOpacity(0.5),
            offset: Offset(1.5.w, 0),
            blurRadius: 7.w,
            spreadRadius: 0.w,
          ),
        ],
      ),
      child: Slidable(
        enabled: model.isMy == 1  ? true : false,
        endActionPane: ActionPane(
          motion: const ScrollMotion(),
          children: [
            SlidableAction(
              // An action can be bigger than the others.
              onPressed: (BuildContext context){
                if (onTapEdit !=null) onTapEdit!();

              },
              backgroundColor: const Color(0xFFEB914A),
              foregroundColor: Colors.white,
              // icon: Icons.archive,
              label: '编辑',
            ),
            SlidableAction(
              // An action can be bigger than the others.
              onPressed: (BuildContext context){
                if (onTapDel !=null) onTapDel!();
              },
              backgroundColor: const Color(0xFFAE1414),
              foregroundColor: Colors.white,
              // icon: Icons.archive,
              label: '删除',
            ),
          ],
        ),
        child: Container(
          padding: EdgeInsets.all(10.w),
          child: Column(
            crossAxisAlignment: CrossAxisAlignment.start,
            children: [
              _showText(model).isEmpty?const SizedBox():Row(
                crossAxisAlignment: CrossAxisAlignment.center,
                children: [
                  Text(_showText(model),style: TextStyle(
                      fontSize: 14.w,
                      height: 1.5,
                      // color: Colors.red,
                      color:Colours.c3
                  ),),
                  Text(_showStatus(model),style: TextStyle(fontSize: 11.w,height: 1.5,color: AppTheme.primary),),
                ],
              ),
              Gaps.vGaps13,
              _buildImageGridView(),
              Gaps.vGaps13,
              _buildAudioListView(),
              Gaps.vGaps13,
              Container(
                width: double.infinity,
                padding: EdgeInsets.symmetric(vertical: 5.w,horizontal: 10.w),
                color: Colours.cF8,
                child:Column(
                  crossAxisAlignment: CrossAxisAlignment.start,
                  children: [
                    Text(model.chapterName??'',style: TextStyle(fontSize: 12.w,height: 1.5,color: Colours.c9),),
                    Text('内容：${model.content??''}',style: TextStyle(fontSize: 12.w,height: 1.5,color: Colours.c9),),
                  ],
                )
              )
            ],
          ),
        ),
      ),
    );
  }

  String _showText(NoteModel discussModel){

    String text = '';
    // // 是我的
    // if(discussModel.isMy == 1){
    //   text = '${discussModel.noteContent?.text?.content}';
    // }
    text = '${discussModel.noteContent?.text?.content}';
    return text;
  }
  String _showStatus(NoteModel discussModel){
    String text = '';
    // 是我的
    if(discussModel.isMy == 1){
      // 审核中
      if(discussModel.noteContent?.text?.privacyStatus ==0 ||discussModel.noteContent?.text?.privacyStatus ==2){
        text = '(审核中)';
      }
      // 审核未通过
      else if(discussModel.noteContent?.text?.privacyStatus ==-1){
        text = '(审核未通过)';
      }
      // 审核通过
      else {
        text = '';
      }
    }
    return text;
  }

  String _showImageStatus(NoteModel discussModel,MediaModel? mediaModel){
    String text = '';
    // 是我的
    if(discussModel.isMy == 1){
      // 审核中
      if(mediaModel?.privacyStatus ==0 ||mediaModel?.privacyStatus ==2){
        text = '(审核中)';
      }
      // 审核未通过
      else if(mediaModel?.privacyStatus ==-1){
        text = '(审核未通过)';
      }
      // 审核通过
      else {
        text = '';
      }
    }
    return text;
  }
  // 图片
  Widget _buildImageGridView(){
    return GridView.builder(
      // padding: const EdgeInsets.only(left: 13,top: 10),
      physics: const NeverScrollableScrollPhysics(),
      shrinkWrap: true,
      gridDelegate: SliverGridDelegateWithFixedCrossAxisCount(
          crossAxisCount: 6,
          crossAxisSpacing: 2.w,
          mainAxisSpacing: 2.w,
          childAspectRatio: 1
      ),
      itemBuilder: (BuildContext context, int index) {
        MediaModel? mediaModel = model.noteContent?.image?[index];
        List<String>images = model.noteContent?.image?.map((MediaModel model) => model.content??'').toList()??[];
        return GestureDetector(
          onTap: (){
            context.pushNamed(Routes.imageView,extra:images);
          },
          child: Stack(
            children: [
              Positioned(
                left: 0,
                right:0,
                top:0,
                bottom: 0,
                child: CustomImage.network(url: mediaModel?.content??'',fit: BoxFit.cover,)
              ),
              Visibility(
                visible: true,
                child: Positioned(
                    left: 0,
                    right:0,
                    top:0,
                    bottom: 0,
                    child: Container(
                      alignment: Alignment.center,
                      // color: model.isMy==1?Colours.c9.withOpacity(0.5):Colours.c9.withOpacity(1),
                      child: Text(_showImageStatus(model,mediaModel),style: TextStyle(fontSize: 11.w,height: 1.5,color: AppTheme.primary),),
                    )
                ),
              ),
            ],
          ),
        );
      },
      itemCount: model.noteContent?.image?.length,
    );
  }

  Widget _buildAudioListView(){
    return ListView.builder(
      physics: const NeverScrollableScrollPhysics(),
      shrinkWrap: true,
      itemBuilder: (BuildContext context, int index) {
        MediaModel mediaModel = model.noteContent!.audio![index];
        return Container(
          height: 20.w,
          margin: EdgeInsets.only(right: 130.w),
          child: Container(
            margin: EdgeInsets.only(top: 5.w),
            padding: EdgeInsets.only(right:20.w,left: 10.w),
            decoration: BoxDecoration(
              borderRadius: BorderRadius.circular(10.w),
              color: Colours.cF9,
            ),
            child: Row(
              // mainAxisSize: MainAxisSize.min,
              mainAxisAlignment:MainAxisAlignment.spaceBetween,
              children: [
                GestureDetector(
                  onTap: (){
                    // 我的录音 或者 已经审核通过的录音才可以播放
                    if(model.isMy == 1 || mediaModel.privacyStatus == 1){
                      if (onTapAudio !=null) onTapAudio!(mediaModel);
                    }
                    else{
                      Toast.show('当前音频处于审核中');
                    }

                  },
                    child: Image.asset('assets/images/audio.png')
                ),
                Text('${mediaModel.currentDuration}/${mediaModel.duration}',style: TextStyle(fontSize: 10.w,height: 1.4,color: Colours.c9),)
              ],
            ),
          ),
        );
      },
      itemCount: model.noteContent?.audio?.length,
    );
  }
}
