part of user_gender;

class UserGenderPage extends StatefulWidget {
  final UserInfoModel userInfo;

  const UserGenderPage({Key? key, required this.userInfo}) : super(key: key);

  @override
  State<UserGenderPage> createState() => _UserGenderPageState();
}

class _UserGenderPageState extends State<UserGenderPage> {
  late num? selectedGender ; // 选中的性别
  @override
  void initState() {
    super.initState();
    selectedGender = widget.userInfo.sex;
    // 在这里可以使用 localVariable 进行操作
  }

  @override
  Widget build(BuildContext context) {
    return WillPopScope(
      onWillPop: () async {
        context.pop(true);
        return false;
      },
      child: GetBuilder<UserGenderController>(
        init: UserGenderController(widget.userInfo),
        builder: (controller) => Scaffold(
            appBar: CustomAppBar(
              title: const Text('设置性别'),
              actions: [],
            ),
            body: Container(
              margin: EdgeInsets.symmetric(
                  horizontal: AppTheme.margin, vertical: AppTheme.margin),
              decoration: BoxDecoration(
                borderRadius: BorderRadius.circular(8.w),
                color: Colors.white,
                boxShadow: [
                  BoxShadow(
                    color:  Color(0xFFC7C7C7).withOpacity(0.5),
                    offset:  Offset(3.w, 0),
                    blurRadius: 10.w,
                    spreadRadius: 0.w,
                  ),
                ],
              ),
              child: ClipRRect(
                borderRadius: BorderRadius.circular(8.w),
                child: Column(
                  mainAxisSize: MainAxisSize.min,
                  children: [
                    /// 男
                    GestureDetector(
                      onTap: () {
                        // print("点击了男");
                        setState(() {
                          controller._changeInfo(1);
                          selectedGender = 1;
                        });
                      },
                      child: Container(
                        padding: EdgeInsets.only(left: 15.w, right: 15.w),
                        color: Colors.transparent,
                        height: 35.w,
                        child: Row(
                          mainAxisAlignment: MainAxisAlignment.spaceBetween,
                          crossAxisAlignment: CrossAxisAlignment.center,
                          children: [
                            Text(
                              "男",
                              style: TextStyle(
                                fontSize: 14.w,
                                color: Colours.c3,
                              ),
                            ),
                            Visibility(
                                visible: selectedGender == 1,
                                // child: Image.asset('assets/images/check.png'))
                                child: Image(
                                  image:
                                  const AssetImage("assets/images/check.png"),
                                  height: 15.w,
                                  width: 15.w,
                                )),
                          ],
                        ),
                      ),

                      /* Row(
                      mainAxisAlignment: MainAxisAlignment.spaceBetween,
                      children: [
                        _buildItem(
                          '男',
                        ),
                        Padding(
                            padding: const EdgeInsets.only(right: 18),
                            child: Visibility(
                                visible: selectedGender == 1,
                                child: Image.asset('assets/images/check.png'))),
                      ],
                    )*/
                    ),
                    Container(
                      color: Colours.cLine,
                      margin: EdgeInsets.symmetric(horizontal: 10.w),
                      height: 1.w,
                    ),
                    GestureDetector(
                      onTap: () {
                        setState(() {
                          controller._changeInfo(2);
                          selectedGender = 2;
                        });
                      },
                      child: Container(
                        padding: EdgeInsets.only(left: 15.w, right: 15.w),
                        color: Colors.transparent,
                        height: 35.w,
                        child: Row(
                          mainAxisAlignment: MainAxisAlignment.spaceBetween,
                          crossAxisAlignment: CrossAxisAlignment.center,
                          children: [
                            Text(
                              "女",
                              style: TextStyle(
                                fontSize: 14.w,
                                color: Colours.c3,
                              ),
                            ),
                            Visibility(
                                visible: selectedGender == 2,
                                child: Image(
                                  image:
                                  const AssetImage("assets/images/check.png"),
                                  height: 15.w,
                                  width: 15.w,
                                ))
                          ],
                        ),
                      ),

                      /*Row(
                      mainAxisAlignment: MainAxisAlignment.spaceBetween,
                      children: [
                        _buildItem(
                          '女',
                        ),
                        Padding(
                            padding: const EdgeInsets.only(right: 18),
                            child: Visibility(
                                visible: selectedGender == 2,
                                child: Image.asset('assets/images/check.png'))),
                      ],
                    )*/
                    ),
                    Container(
                      color: Colours.cLine,
                      margin: EdgeInsets.symmetric(horizontal: 10.w),
                      height: 1,
                    ),
                    GestureDetector(
                      onTap: () {
                        setState(() {
                          controller._changeInfo(3);
                          selectedGender = 3;
                        });
                      },
                      child: /*Row(
                      mainAxisAlignment: MainAxisAlignment.spaceBetween,
                      children: [
                        _buildItem(
                          '保密',
                        ),
                        Padding(
                            padding: const EdgeInsets.only(right: 18),
                            child: Visibility(
                                visible: selectedGender == 3,
                                child: Image.asset('assets/images/check.png'))),
                      ],
                    )*/

                      Container(
                        padding: EdgeInsets.only(left: 15.w, right: 15.w),
                        color: Colors.transparent,
                        height: 35.w,
                        child: Row(
                          mainAxisAlignment: MainAxisAlignment.spaceBetween,
                          crossAxisAlignment: CrossAxisAlignment.center,
                          children: [
                            Text(
                              "保密",
                              style: TextStyle(
                                fontSize: 14.w,
                                color: Colours.c3,
                              ),
                            ),
                            Visibility(
                                visible: selectedGender == 3,
                                child: Image(
                                  image:
                                  const AssetImage("assets/images/check.png"),
                                  height: 15.w,
                                  width: 15.w,
                                ))
                          ],
                        ),
                      ),
                    ),
                  ],
                ),
              ),
            ))
      ),
    );
  }

}
