part of web;

class ReadController extends FullLifeCycleController with GetSingleTickerProviderStateMixin{

  // 目录
  List <ChapterModel> chapters = [];
  List <ToolModel> tools = [
    ToolModel(tag: 0,name: '目录',selected: false,icon: 'assets/images/category_unselect.png',activeIcon: 'assets/images/category_select.png'),
    ToolModel(tag: 1,name: '笔记',selected: false,icon: 'assets/images/note_unselect.png',activeIcon:'assets/images/note_select.png'),
    ToolModel(tag: 2,name: '讨论',selected: false,icon: 'assets/images/discuss_unselect.png',activeIcon:'assets/images/discuss_select.png'),
  ];

  late ToolModel toolModel = tools.first;

  // late final PageController pageController;
  //
  // //默认显示
  // int currentPage = 1;

  bool  showChat = false;

  final FocusNode commentFocusNode = FocusNode();


  late AnimationController _controller;
  bool _show = true;

  bool get show => _show;
  void setShow(bool value) {
    _show = !value;
    if (_show) {
      /// 显示状态栏
      SystemChrome.setEnabledSystemUIMode(SystemUiMode.edgeToEdge);
      /// 开启动画
      _controller.forward();
    }
    else {
      /// 不显示状态栏
      // SystemChrome.setEnabledSystemUIMode(SystemUiMode.immersiveSticky);
      /// 收回动画
      _controller.reverse();
    }
    update();
  }


  void chooseTool(ToolModel selectedModel){
    for (var model in tools) {
      // 如果当前遍历到的工具是选中的，并且不是点击的工具，则取消选中
      if (model.selected && model != selectedModel) {
        model.selected = false;
      }
      // 如果当前遍历到的工具是点击的工具，切换选中状态
      else if (model == selectedModel) {
        model.selected = !model.selected;
      }
    }
    toolModel = selectedModel;
    update();
  }


  AnimationController get controller => _controller;

  void _onCommentFocusChanged() {
    if (commentFocusNode.hasFocus) {
      setShowChat(true);
    } else {
      setShowChat(false);
    }
  }

  void setShowChat(bool value) {
    showChat = value;
    update();
  }

  @override
  void onInit() {
    // pageController = PageController(initialPage: currentPage);
    commentFocusNode.addListener(_onCommentFocusChanged);
    /// 默认不显示状态栏
    // SystemChrome.setEnabledSystemUIMode(SystemUiMode.immersiveSticky);
    /// 初始化
    _controller = AnimationController(
      vsync: this,
      duration: const Duration(milliseconds: 100),
    );
    super.onInit();
  }

  @override
  void onReady() {
    _getChapters();
    super.onReady();
  }

  @override
  void onClose() {
    _controller.dispose();
    commentFocusNode.removeListener(_onCommentFocusChanged);
    commentFocusNode.dispose();
    super.onClose();
  }


  void onPageChanged(int page) {
    // currentPage = page;
    update(['navigation']);
  }

  void onResumed(){
    print('onResumed');
  }
  void onPaused(){
    print('onPaused');
  }
  void onInactive(){
    print('onInactive');
  }
  void onDetached(){
    print('onDetached');
  }



  /// 获取目录信息
  void _getChapters() async {
    chapters = await LibraryAPI.chapters(bookId: '110');
    update();
  }
}

class ToolModel {
  ToolModel({required this.tag, required this.selected, required this.name,required this.icon,required this.activeIcon});
  int tag;
  String name;
  bool selected;
  String icon;
  String activeIcon;
}