part of web;

class ReadPage extends StatefulWidget {
  const ReadPage({Key? key}) : super(key: key);

  @override
  State<ReadPage> createState() => _ReadPageState();
}

class _ReadPageState extends State<ReadPage> {

  int currentIndex = 0;
  final GlobalKey webViewKey = GlobalKey();
  InAppWebViewController? webViewController;
  late ContextMenu contextMenu;
  @override
  void initState() {
    super.initState();
  }
  @override
  Widget build(BuildContext context) {
    return GetBuilder<ReadController>(
      init: ReadController(),
      builder: (readController) => Scaffold(

       body: Container(
         color: Colors.white,
         child: Stack(
           children: [
             Container(
               height: 40,
               width: double.infinity,
               color: Colors.lightBlue,
             ),
             InAppWebView(
               initialUrlRequest: URLRequest(
                 url: Uri.parse('http://192.168.11.39:5500/'),
               ),
               onWebViewCreated: (InAppWebViewController controller) {
                 webViewController = controller;
               },
               onLoadStop: (controller, url) {
                 controller.addJavaScriptHandler(handlerName: 'onTap', callback: (args){
                   readController.setShow(readController.show);

                 });
                 controller.evaluateJavascript(source: '''
                    document.addEventListener('click', function() {
                      window.flutter_inappwebview.callHandler('onTap');
                    });
                  ''');
               },
             ),
             AnimatedPositioned(
               duration: readController.controller.duration!,
               curve: Curves.easeInOut,
               top: readController.show ? 0 : -100, // 负值隐藏，0 显示
               left: 0,
               right: 0,
               height: 100,
               child: Container(
                 color: Colors.limeAccent,
                 alignment: Alignment.center,
                 child: Text('top View'),
               ),
             ),
             Positioned(
               left: 0,
               right: 0,
               top: 0,
               bottom: 49 + MediaQuery.of(context).viewInsets.bottom,
               child: _showContent(readController,readController.toolModel)
             ),
             AnimatedPositioned(
               duration: readController.controller.duration!,
               curve: Curves.easeInOut,
               bottom: readController.show ? 0 : -49 - MediaQuery.of(context).viewInsets.bottom, // 负值隐藏，0 显示
               left: 0,
               right: 0,
               height: 49,
               child: Container(
                 color: Colors.limeAccent,
                 alignment: Alignment.center,
                 child: _createToolBar(readController)
               ),
             ),

           ],
         ),
       ),
      ),
    );

  }

  Widget _createToolBar(ReadController controller){
    return Container(
      child: Row(
        mainAxisAlignment: MainAxisAlignment.spaceAround,
        children: controller.tools.map((model){
          return Expanded(
            child: GestureDetector(
              onTap: (){
                controller.chooseTool(model);
              },
              child: Container(
                color: Colors.white,
                child: Column(
                  mainAxisAlignment: MainAxisAlignment.center,
                  mainAxisSize: MainAxisSize.max,
                  children: [
                    SizedBox(
                      width: 17,
                      height: 17,
                      child: Image.asset(model.selected?model.activeIcon:model.icon)
                    ),
                    // SizedBox(height: 2.5.w,),
                    model.selected?Text(model.name,style: TextStyle(fontSize: 10.w,height: 1.4,fontWeight: Fonts.medium,color: AppTheme.primary),)
                        :Text(model.name,style: TextStyle(fontSize: 10.w,height: 1.4,fontWeight: Fonts.medium,color: Colours.c6))
                  ],
                ),
              ),
            ),
          );
        }).toList()
      ),
    );
  }

  Widget _showContent(ReadController controller,ToolModel model) {
    print('++++++++++++++++++++++++${model.tag}');
    if (controller.show){
      if (model.tag == 0){
        return model.selected? Container(
          color: Color(0xFF000000).withOpacity(0.5),
          padding: EdgeInsets.only(top: MediaQuery.of(context).size.height * 0.2),
          child: ClipRRect(
            borderRadius: BorderRadius.only(topRight: Radius.circular(8.w),topLeft: Radius.circular(8.w)),
            child: Container(
              color: Colors.white,
              child: ReadCategoryPage(controller: controller,onTap: (){
                controller.chooseTool(model);
              },),
            ),
          ),
          // child: ReadCategoryPage(),
        ):const SizedBox();
      }
      else if (model.tag == 1){
        return model.selected? Container(
          color: Color(0xFF000000).withOpacity(0.5),
          padding: EdgeInsets.only(top: MediaQuery.of(context).size.height * 0.2),
          child: ClipRRect(
            borderRadius: BorderRadius.only(topRight: Radius.circular(8.w),topLeft: Radius.circular(8.w)),
            child: Container(
              color: Colors.white,
              child: ReadNotePage(onTap: (){
                controller.chooseTool(model);
              },),
            ),
          ),
          // child: ReadCategoryPage(),
        ):const SizedBox();
      }
      else if (model.tag == 2){
        return model.selected? Container(
          color: Color(0xFF000000).withOpacity(0.5),
          padding: EdgeInsets.only(top: MediaQuery.of(context).size.height * 0.2),
          child: ClipRRect(
            borderRadius: BorderRadius.only(topRight: Radius.circular(8.w),topLeft: Radius.circular(8.w)),
            child: Container(
              color: Colors.white,
              child: ReadDiscussPage(onTap: (){
                controller.chooseTool(model);
              },),
            ),
          ),
          // child: ReadCategoryPage(),
        ):const SizedBox();
      }
    }
    return const SizedBox();
  }
}
