part of book_score;

class BuildItem extends StatelessWidget {
  final ScoreModel model;
  const BuildItem({
    Key? key,
    required this.model
  }) : super(key: key);

  @override
  Widget build(BuildContext context) {
    return Container(
      margin: EdgeInsets.only(left: 10.w, top: 10.w, right: 10.w),
      child: Container(
        padding: EdgeInsets.only(left: 15.w, top: 15.w,right: 10.w,bottom: 15.w),
        decoration: BoxDecoration(
          color: Colors.white,
          boxShadow: [
            BoxShadow(
              color: Colours.cC7.withOpacity(0.5),
              offset: Offset(3.w, 0.w),
              blurRadius: 4.w,
              spreadRadius: 0,
            ),
          ],
          borderRadius: BorderRadius.circular(8.w)
        ),
        child: Column(
          crossAxisAlignment: CrossAxisAlignment.start,
          children: [
            Row(
              children: [
                Container(
                  width:  35.w,
                  height: 35.w,
                  decoration: BoxDecoration(
                    color: Colors.cyan,
                    borderRadius: BorderRadius.circular(17.5.w)
                  ),
                  child: CustomImage.network(url: model.usersImg??'',radius: 17.5.w,),
                ),
                Gaps.hGaps10,
                Expanded(
                  child: Column(
                    crossAxisAlignment: CrossAxisAlignment.start,
                    children: [
                      Row(
                        mainAxisAlignment: MainAxisAlignment.spaceBetween,
                        children: [
                          Text(model.users??'',style: TextStyle(fontSize: 12.w,height: 1.3,color: Colours.c9),),
                          // Spacer(),
                          Text(model.createTime??'',style: TextStyle(fontSize: 12.w,height: 1.3,color: Colours.c9),)
                        ],
                      ),
                      AbsorbPointer(
                        absorbing: true,
                        child: CustomRating(
                          max: 5,
                          score:model.rating!.toDouble() ,
                          star: Star(
                            progress: 7,
                            fillColor: AppTheme.primary,
                            size: 12.w,
                            emptyColor: Colours.cE2,
                          ), onRating: (double ) {},
                        ),
                      ),
                    ],
                  ),
                )
              ],
            ),
            Gaps.vGaps15,
            Text(model.comments??'',style: TextStyle(fontSize: 14.w,height: 1.5,color: Colours.c3),)
          ],
        ),
      ),
    );
  }
}
