part of models;

/// book_id : 2
/// book_name : "五禽戏"
/// authors : "华佗"
/// img : "https://resource.vning.net/book/img/vning_hEBkC8RG26_1646976647301.jpg"
/// progress : "0%"
/// lastChapter  : "最近章节"
/// createTime  : "创建时间"
/// introduction  ： "介绍"
///

class CourseModel {
  CourseModel({
      this.bookId, 
      this.bookName, 
      this.authors, 
      this.img, 
      this.progress,
      this.lastChapter,
      this.createTime,
      this.days,
      this.introduction,
      this.readNum,
      this.isCollection,
      this.collectionId,

      /// 购物车列表需要参数
      this.price,
      this.vipPrice,
      this.status,
      this.cartId
      ///

  });

  CourseModel.fromJson(dynamic json) {
    bookId = json['book_id'];
    bookName = json['book_name'];
    authors = json['authors'];
    img = json['img'];
    progress = json['progress'];
    lastChapter = json['last_chapter'];
    createTime = json['create_time'];
    days = json['days'];
    introduction = json['introduction'];
    readNum = json['read_num'];
    isCollection = json['is_collection'];
    collectionId = json['collection_id'];
  }
  num? bookId;
  String? bookName;
  String? authors;
  String? img;
  String? progress;
  String? lastChapter;
  String? createTime;
  String? days;
  String? introduction;
  num? readNum;
  num? isCollection;
  num? collectionId;

  /// 购物车列表需要参数
  String? price;
  String? vipPrice;
  num? status;
  num? cartId;
  ///



  int get type {
    if (progress == '0.00%'){
      return 0;
    } else if (progress == '100.00%'){
      return 1;
    } else {
      return 2;
    }
  }

  String get typeName {
    if (progress == '0.00%'){
      return '未学习';
    } else if (progress == '100.00%'){
      return '已学完';
    } else {
      return '已学习$progress';
    }
  }

  CourseModel copyWith({  num? bookId,
    String? bookName,
    String? authors,
    String? img,
    String? progress,
    String? lastChapter,
    String? createTime,
    String? days,
    String? introduction,
    num? readNum,
    num? isCollection,
    num? collectionId,

    /// 购物车列表需要参数
    String? price,
    String? vipPrice,
    num? status,
    num? cartId,
    ///

  }) => CourseModel(  bookId: bookId ?? this.bookId,
    bookName: bookName ?? this.bookName,
    authors: authors ?? this.authors,
    img: img ?? this.img,
    progress: progress ?? this.progress,
    lastChapter: lastChapter ?? this.lastChapter,
    createTime: createTime ?? this.createTime,
    days: days ?? this.days,
    introduction: introduction ?? this.introduction,
    readNum: readNum ?? this.readNum,
    isCollection: isCollection ?? this.isCollection,
    collectionId: collectionId ?? this.collectionId,
    /// 购物车列表需要参数
    price: price ?? this.price,
    vipPrice: vipPrice ?? this.vipPrice,
    status: status ?? this.status,
    cartId: cartId ?? this.cartId,
    ///
  );

  Map<String, dynamic> toJson() {
    final map = <String, dynamic>{};
    map['book_id'] = bookId;
    map['book_name'] = bookName;
    map['authors'] = authors;
    map['img'] = img;
    map['progress'] = progress;
    map['last_chapter'] = lastChapter;
    map['create_time'] = createTime;
    map['days'] = days;
    map['read_num'] = readNum;
    map['is_collection'] = isCollection;
    map['collection_id'] = collectionId;
    map['introduction'] = introduction;
    map['price'] = price;
    map['vip_price'] = vipPrice;
    map['status'] = status;
    map['cart_id'] = cartId;

    return map;
  }

}