part of services;

class StorageService extends GetxService {
  static StorageService get to => Get.find();
  late final SharedPreferences _prefs;

  ///初始化 StorageService
  Future<StorageService> init() async {
    _prefs = await SharedPreferences.getInstance();
    // 返回 StorageService 实例
    return this;
  }

  ///存储字符串
  Future<bool> setString(String key, String value) async {
    return await _prefs.setString(key, value);
  }

  ///存储bool类型
  Future<bool> setBool(String key, bool value) async {
    return await _prefs.setBool(key, value);
  }

  ///存储list类型
  Future<bool> setList(String key, List<String> value) async{
    return await _prefs.setStringList(key, value);
  }

  ///获取字符串
  String getString(String key) {
    return _prefs.getString(key) ?? '';
  }

  ///获取bool
  bool getBool(String key) {
    return _prefs.getBool(key) ?? false;
  }

  ///获取list
  List<String> getList(String key) {
    return _prefs.getStringList(key) ?? [];
  }

  ///移除key
  Future<bool> remove(String key) async {
    return await _prefs.remove(key);
  }








}