part of change_pwd;

class ChangePwdPage extends StatefulWidget {
  final UserInfoModel userInfo;
  const ChangePwdPage({
    Key? key ,
    required this.userInfo,
  }) : super(key: key);
  // const ResetPwdPage({Key? key}) : super(key: key);

  @override
  State<ChangePwdPage> createState() => _ChangePwdPageState();
}

class _ChangePwdPageState extends State<ChangePwdPage> {
  @override
  Widget build(BuildContext context) {
    final currentContext = context;
    return GetBuilder<ChangePwdController>(
      init: ChangePwdController(widget.userInfo),
      builder: (controller) =>Scaffold(
        appBar: AppBar(
          centerTitle: true,
          title: Text(widget.userInfo.password.toString().isEmpty?'设置密码':'修改密码'),
        ),
        body: Container(
          margin: EdgeInsets.only(left: 10.w,top: 15.w,right: 10.w),
          child: Column(
            crossAxisAlignment: CrossAxisAlignment.start,
            children: [
              ValueListenableBuilder<bool>(
                valueListenable: controller.showPassword,
                builder:(context, value, child) => Container(
                  decoration: BoxDecoration(
                    borderRadius: BorderRadius.circular(8.w),
                    color: const Color(0xFFF9F9F9),
                    boxShadow: [
                      BoxShadow(
                        color: const Color(0xFFC7C7C7).withOpacity(0.35),
                        offset: Offset(3.w, 0),
                        blurRadius: 10.w,
                        spreadRadius: 0.w,
                      ),
                    ],
                  ),
                  child: ClipRRect(
                    borderRadius: BorderRadius.circular(8.w),
                    child: CustomFormInput(
                      obscureText: !value,
                      hintText: '请输入新密码',
                      iconData:
                      value ? Image.asset(
                        'assets/images/eye_open.png',
                      )  : Image.asset(
                        'assets/images/eye_close.png',
                      ),
                      controller: controller.pwdInput,
                      onChanged: (text){
                        controller.setCanClick();
                      },
                      decoration: const InputDecoration(
                          focusedBorder: InputBorder.none,
                          border: InputBorder.none,
                          enabledBorder: InputBorder.none,
                          errorBorder: InputBorder.none
                      ),
                      onIcon: controller.onShowPassword,
                    ),
                  ),
                ),
              ),
              Gaps.vGaps10,
              ValueListenableBuilder<bool>(
                valueListenable: controller.showPassword2,
                builder:(context, value, child) => Container(
                  decoration: BoxDecoration(
                    // borderRadius: BorderRadius.circular(8),
                    color: const Color(0xFFF9F9F9),
                    boxShadow: [
                      BoxShadow(
                        color: const Color(0xFFC7C7C7).withOpacity(0.35),
                        offset: Offset(3.w, 0),
                        blurRadius: 10.w,
                        spreadRadius: 0.w,
                      ),
                    ],
                  ),
                  child: ClipRRect(
                    borderRadius: BorderRadius.circular(8.w),
                    child: CustomFormInput(
                      obscureText: !value,
                      hintText: '请再次输入密码',
                      iconData:
                      value ? Image.asset(
                        'assets/images/eye_open.png',
                      )  : Image.asset(
                        'assets/images/eye_close.png',
                      ),
                      controller: controller.pwd2Input,
                      onChanged: (text){
                        controller.setCanClick();
                      },
                      decoration: const InputDecoration(
                          focusedBorder: InputBorder.none,
                          border: InputBorder.none,
                          enabledBorder: InputBorder.none,
                          errorBorder: InputBorder.none
                      ),
                      onIcon: controller.onShowPassword2,
                    ),
                  ),
                ),
              ),
              Container(
                margin: EdgeInsets.only(left: 5.w,top: 5.w),
                child: Text('密码必须是8-20个英文字母、数字或符号(除空格)',style: TextStyle(fontSize: 10.w,color: Colours.c9),),
              ),
              Gaps.vGaps40,
              CustomGradientButton(
                text: widget.userInfo.password.toString().isEmpty ?'确认':'确认修改',
                isEnabled: controller.enable,
                onPressed: () async {
                  Tools.unfocus();
                  final result = await controller.changePwd();
                  if (result){
                    Toast.show('修改成功');
                    context.pop();
                  }
                  // context.goNamed(Routes.login);
                },
              )
            ],
          ),
        ),
      ),
    );
  }
}
