part of apis;

abstract class CourseAPI {

  /// 获取课程 内书籍列表
  static Future <List<CourseModel>> list({
    int page = 1,
    int limit = 20,
  }) async {
    final result = await HttpService.to.post(
      '/v1/members/Information/myCourse',
      params: {
        'currentPage': page,
        'pageSize': limit,
      },
    );
    if (result.data is! Map && result.data['list'] is! List) return [];
    return List.generate(result.data['list'].length, (index){
       return CourseModel.fromJson(result.data['list'][index]);
    });
  }

}