part of course;

class CoursePage extends StatefulWidget {
  const CoursePage({Key? key}) : super(key: key);

  @override
  State<CoursePage> createState() => _CoursePageState();
}

class _CoursePageState extends State<CoursePage> {
  @override
  Widget build(BuildContext context) {
    return GetBuilder<CourseController>(
      init: CourseController(),
      builder: (controller) =>Scaffold(
          appBar: CustomAppBar(
            titleSpacing: 0,
            title:  Padding(
              padding: const EdgeInsets.symmetric(horizontal: AppTheme.margin),
              child: CustomInputSearch(
                readOnly:true,
                hintText: '请输入书籍名称',
                onTap: () {
                  context.pushNamed(Routes.search);
                }
              ),
            ),
            actions: [
              CustomButton.icon(
                padding: EdgeInsets.zero,
                backgroundColor: Colors.transparent,
                icon: Image.asset(
                  'assets/images/read_history.png',
                ),
                onPressed: () => context.pushNamed(Routes.studyHistory),
              ),
              GestureDetector(
                onTap: (){
                  context.pushNamed(Routes.msgs);
                  // controller.logout(context);
                },
                child: badges.Badge(
                  position: badges.BadgePosition.topEnd(top: -5, end: 0),
                  badgeContent: const Text('10',style: TextStyle(fontSize: 7,color: Colors.white),),
                  badgeStyle: const badges.BadgeStyle(
                    badgeColor: AppTheme.primary,
                    shape: badges.BadgeShape.circle
                  ),
                  child: CustomButton.icon(
                      padding: EdgeInsets.zero,
                      backgroundColor: Colors.transparent,
                      icon: Image.asset(
                        'assets/images/msg_black.png',
                      ),
                      // onPressed: () => context.pushNamed(Routes.msgs),
                    ),
                ),
              )
              // CustomButton.icon(
              //   padding: EdgeInsets.zero,
              //   backgroundColor: Colors.transparent,
              //   icon: const Icon(Ionicons.notifications),
              //   onPressed: () => context.pushNamed(Routes.msgs),
              // ),
            ],
          ),
          body:Container(
            color: const Color(0xFFF9F9F9),
            child: Column(
              children: [
                Container(
                  color: Colors.transparent,
                    padding: const EdgeInsets.symmetric(horizontal: 10),
                    child: const BuildBanner(items: ['111','222','333'],),
                ),
                Expanded(
                  child: CustomPullScrollView(
                    controller: controller.refreshController,
                    onRefresh: controller.onRefresh,
                    onLoading: controller.onLoading,
                    child: GridView.builder(
                        padding: const EdgeInsets.only(left: 13,top: 10),
                        gridDelegate: const SliverGridDelegateWithFixedCrossAxisCount(
                            crossAxisCount: 2,
                          crossAxisSpacing: 0,
                          mainAxisSpacing: 10,
                          childAspectRatio: 0.85
                        ),
                        itemBuilder: (BuildContext context, int index) {
                          return GestureDetector(
                              child: Book(model: controller.courses[index],),
                            onTap: (){
                                context.pushNamed(Routes.bookDetail);
                            },
                          );
                        },
                       itemCount: controller.courses.length,
                    ),
                  ),
                ),
              ],
            ),
          )
    ));
  }
}


