part of user_info;

class UserInfoPage extends StatefulWidget {
  final UserInfoModel userInfo;

  const UserInfoPage({Key? key, required this.userInfo}) : super(key: key);

  @override
  State<UserInfoPage> createState() => _UserInfoPageState();
}

class _UserInfoPageState extends State<UserInfoPage> {
  @override
  Widget build(BuildContext context) {
    return GetBuilder<UserInfoController>(
        init: UserInfoController(widget.userInfo),
        builder: (controller) => Stack(
              children: [
                Scaffold(
                    appBar: AppBar(
                      title: const Text('个人信息'),
                      centerTitle: true,
                    ),
                    body: Container(
                      margin: EdgeInsets.symmetric(
                          horizontal: AppTheme.margin,
                          vertical: AppTheme.margin),
                      decoration: BoxDecoration(
                        borderRadius: BorderRadius.circular(8.w),
                        color: Colors.white,
                        boxShadow: [
                          BoxShadow(
                            color: const Color(0xFFC7C7C7).withOpacity(0.5),
                            offset: Offset(3.w, 0),
                            blurRadius: 10.w,
                            spreadRadius: 0.w,
                          ),
                        ],
                      ),
                      child: ClipRRect(
                        borderRadius: BorderRadius.circular(8.w),
                        child: Column(
                          mainAxisSize: MainAxisSize.min,
                          children: [
                            /// 头像
                            Container(
                              height: 52.w,
                              padding: EdgeInsets.only(left: 18.w, right: 15.w),
                              child: GestureDetector(
                                onTap: () {

                                  controller.show();
                                  Console.log('点击头像');
                                },
                                child: Container(
                                  color: Colors.transparent,
                                  child: Row(
                                    mainAxisAlignment:
                                        MainAxisAlignment.spaceBetween,
                                    children: [
                                      Text(
                                        '头像',
                                        style: TextStyle(
                                            color: Colours.c3,
                                            fontSize: 14.w,
                                            height: 1.6),
                                      ),
                                      Row(
                                        children: [
                                          Container(
                                            width: 33.w,
                                            height: 33.w,
                                            decoration: const BoxDecoration(
                                              shape: BoxShape.circle,
                                              color: Colors.cyan,
                                            ),
                                            child: CustomImage.network(
                                              url:
                                                  controller.userInfo.headImg ??
                                                      '',
                                              radius: 16.5,
                                            ),
                                          ),
                                          Gaps.hGaps10,
                                          SizedBox(
                                            width: 5.w,
                                            height: 8.w,
                                            child: Image.asset(
                                                'assets/images/right_arrow.png'),
                                          )
                                        ],
                                      )
                                    ],
                                  ),
                                ),
                              ),
                            ),
                            Container(
                              color: Colours.cLine,
                              margin: EdgeInsets.symmetric(horizontal: 15.w),
                              height: 1.w,
                            ),
                            GestureDetector(
                                onTap: () {
                                  context.pushNamed(Routes.nike,
                                      extra: controller.userInfo);
                                },
                                child: _buildItem(
                                  '昵称',
                                  widget.userInfo.name ?? '',
                                )),
                            Container(
                              color: Colours.cLine,
                              margin: EdgeInsets.symmetric(horizontal: 15.w),
                              height: 1.w,
                            ),
                            GestureDetector(
                                onTap: () {
                                  context.pushNamed(Routes.gender,
                                      extra: controller.userInfo);
                                },
                                child: _buildItem(
                                    '性别', getGender(widget.userInfo.sex)
                                    // widget.userInfo.sex == 1 ? '男' : '女',
                                    )),
                          ],
                        ),
                      ),
                    )),
                controller.showDetail?Positioned(
                  left: 0.w,
                  bottom: 0.w,
                  right: 0.w,
                  top: 0.w,
                  child: GestureDetector(
                    onTap: (){
                      controller.show();
                    },
                    child: Container(
                      color:const  Color(0xFF000000).withOpacity(0.5),
                      child: Align(
                        alignment: Alignment.bottomCenter,
                        child: ClipRRect(
                          borderRadius: BorderRadius.only(topRight: Radius.circular(8.w),topLeft: Radius.circular(8.w)),
                          child: Container(
                            height: 140.5.w,
                            color: Colors.white,
                            child: _buildPic(controller),
                          ),
                        ),
                      ),
                    ),
                  ),
                ):const SizedBox()
              ],
            ));
  }

  Widget _buildPic(UserInfoController controller ){
    return Column(
      children: [
        GestureDetector(
          onTap: () async {
            Console.log("点击拍照");
            final assets = await AssetsPicker.camera(
              context: context,
            );
            controller.upload(path: assets!.path);
          },
          child:  Container(
            height: 45.w,
            padding: EdgeInsets.all(12.w),
            child: const Row(
              mainAxisAlignment: MainAxisAlignment.center,
              children: [
                Text('拍照',textAlign:TextAlign.center,style: TextStyle(fontSize: 15,height: 1.1,color: Colours.c3,fontWeight: Fonts.medium),),
              ],
            ),
          ),
        ),
        Container(height: 0.5.w,color: Colours.cLine,width: double.infinity,),
        GestureDetector(
          onTap: () async {
            Console.log("点击选择现有图片");
             final assets = await AssetsPicker.image(
                          context: context,
                        );
                        controller.upload(path: assets!.path);
          },
          child:  Container(
            height: 45.w,
            padding: EdgeInsets.all(12.w),
            child: const Row(
              mainAxisAlignment: MainAxisAlignment.center,
              children: [
                Text('选择现有图片',textAlign:TextAlign.center,style: TextStyle(fontSize: 15,height: 1.1,color: Colours.c3,fontWeight: Fonts.medium),),
              ],
            ),
          ),
        ),
        Container(height: 5.w,color: Colours.cF9,width: double.infinity,),
        GestureDetector(
          onTap: () {
            Console.log("点击取消");
            controller.show();
          },
          child:  Container(
            height: 45.w,
            padding: EdgeInsets.all(12.w),
            child: const Row(
              mainAxisAlignment: MainAxisAlignment.center,
              children: [
                Text('取消',textAlign:TextAlign.center,style: TextStyle(fontSize: 15,height: 1.1,color: Colours.c3,fontWeight: Fonts.medium),),
              ],
            ),
          ),
        ),
      ],
    );
    return WillPopScope(
      onWillPop: () async {
        context.pop(true);
        return false;
      },
      child: GetBuilder<UserInfoController>(
        init: UserInfoController(widget.userInfo),
        builder: (controller) =>
            Scaffold(
              appBar: AppBar(
                title: const Text('个人信息'),
                centerTitle: true,
              ),
              body: Container(
                margin: EdgeInsets.symmetric(
                    horizontal: AppTheme.margin, vertical: AppTheme.margin),
                decoration: BoxDecoration(
                  borderRadius: BorderRadius.circular(8.w),
                  color: Colors.white,
                  boxShadow: [
                    BoxShadow(
                      color: const Color(0xFFC7C7C7).withOpacity(0.5),
                      offset: Offset(3.w, 0),
                      blurRadius: 10.w,
                      spreadRadius: 0.w,
                    ),
                  ],
                ),
                child: ClipRRect(
                    borderRadius: BorderRadius.circular(8.w),
                    child: Column(
                      mainAxisSize: MainAxisSize.min,
                      children: [

                      /// 头像
                      Container(
                      height: 52.w,
                      padding:  EdgeInsets.only(left: 18.w, right: 15.w),
                      child: GestureDetector(
                        onTap: () async {
                          final assets = await AssetsPicker.image(
                            context: context,
                          );
                          controller.upload(path: assets!.path);
                        },
                        child: Container(
                          color: Colors.transparent,
                          child: Row(
                            mainAxisAlignment: MainAxisAlignment.spaceBetween,
                            children: [
                              Text(
                                '头像',
                                style: TextStyle(
                                    color: Colours.c3,
                                    fontSize: 14.w,
                                    height: 1.6),
                              ),
                              Row(
                                children: [
                                  Container(
                                    width: 33.w,
                                    height: 33.w,
                                    decoration: const BoxDecoration(
                                      shape: BoxShape.circle,
                                      color: Colors.cyan,
                                    ),
                                    child: CustomImage.network(
                                      url: controller.userInfo.headImg ?? '',
                                      radius: 16.5,
                                    ),
                                  ),
                                  Gaps.hGaps10,
                                  SizedBox(
                                    width: 5.w,
                                    height: 8.w,
                                    child: Image.asset(
                                        'assets/images/right_arrow.png'),
                                  )
                                ],
                              )
                            ],
                          ),
                        ),
                      ),
                    ),
                    Container(
                      color: Colours.cLine,
                      margin: EdgeInsets.symmetric(horizontal: 15.w),
                      height: 1.w,
                    ),
                    GestureDetector(
                        onTap: () {
                          context.pushNamed(Routes.nike, extra: controller.userInfo);
                        },
                        child: _buildItem(
                          '昵称',
                          widget.userInfo.name ?? '',
                        )),
                    Container(
                      color: Colours.cLine,
                      margin: EdgeInsets.symmetric(horizontal: 15.w),
                      height: 1.w,
                    ),
                    GestureDetector(
                      onTap: () {
                        context.pushNamed(
                            Routes.gender, extra: controller.userInfo);
                      },
                      child: _buildItem(
                          '性别',
                        getGender(widget.userInfo.sex)
                      // widget.userInfo.sex == 1 ? '男' : '女',
                    )),
                ],
              ),
            ),
      )),),
    );
  }

  getGender(num? sex) {
    String gender;
    if (sex == 1) {
      gender = "男";
    } else if (sex == 2) {
      gender = "女";
    } else {
      gender = "保密";
    }
    return gender;
  }

  Widget _buildItem(String title, String value) {
    return Container(
      padding: EdgeInsets.only(left: 18.w, right: 15.w),
      color: Colors.transparent,
      height: 52.w,
      child: Row(
        mainAxisAlignment: MainAxisAlignment.spaceBetween,
        crossAxisAlignment: CrossAxisAlignment.center,
        children: [
          Text(
            title,
            style: TextStyle(
              fontSize: 14.w,
              color: Colours.c3,
            ),
          ),
          Row(
            children: [
              Text(
                value,
                style: TextStyle(
                  fontSize: 14.w,
                  color: Colours.c9,
                ),
              ),
              Gaps.hGaps10,
              SizedBox(
                width: 5.w,
                height: 8.w,
                child: Image.asset('assets/images/right_arrow.png'),
              )
            ],
          )
        ],
      ),
    );
  }
}
