part of library;

class TestPage extends StatefulWidget {
  const TestPage({Key? key}) : super(key: key);

  @override
  State<LibraryPage> createState() => _LibraryPageState();
}

class _TestPageState extends State<TestPage> with AutomaticKeepAliveClientMixin {

  //AutomaticKeepAliveClientMixin
  @override
  Widget build(BuildContext context) {
    return Scaffold(
      appBar: AppBar(
          title: const Text('分类'),
          bottom: PreferredSize(
            preferredSize: Size.fromHeight(48.w),
            child: Row(
              children: [
                // TabBar放在左侧
                const Expanded(
                  child: TabBar(
                    tabs: [
                      Tab(text: 'Tab 1'),
                      Tab(text: 'Tab 2'),
                      Tab(text: 'Tab 3'),
                      Tab(text: 'Tab 4'),
                      Tab(text: 'Tab 5'),
                    ],
                  ),
                ),

                // 筛选按钮放在右侧
                IconButton(
                  icon: const Icon(Icons.filter_list),
                  onPressed: () {
                    // 处理筛选按钮点击事件
                  },
                ),
              ],
            ),
          )
      ),
      body: Column(
        children: [
          Container(
            height: 43, // 设置标签栏的高度
            color: Colors.cyan, // 设置标签栏的颜色
            // child: // 添加你的横向滑动标签组件
          ),
          Expanded(
            child: CustomScrollView(
              slivers: [
                // // 横向滑动的标签
                // SliverToBoxAdapter(
                //   child: Container(
                //     height: 43, // 设置标签栏的高度
                //     color: Colors.grey, // 设置标签栏的颜色
                //     // child: // 添加你的横向滑动标签组件
                //   ),
                // ),

                // 广告位
                SliverToBoxAdapter(
                    child: Container(
                      height: 100, // 设置广告位的高度
                      color: Colors.grey, // 设置广告位的颜色
                    )
                ),

                SliverFillRemaining(
                  child: TabBarView(
                    children: [
                      // Tab 1 对应的内容
                      Container(
                        color: Colors.red,
                      ),

                      // Tab 2 对应的内容
                      Container(
                        color: Colors.green,
                      ),

                      // Tab 3 对应的内容
                      Container(
                        color: Colors.blue,
                      ),
                      Container(
                        color: Colors.blue,
                      ),
                      Container(
                        color: Colors.blue,
                      ),
                    ],
                  ),
                ),
              ],
            ),
          ),
        ],
      ),
    );
  }


  @override
  bool get wantKeepAlive => true;
}
