part of user_coupon;

class BuildItem extends StatelessWidget {
  final CouponModel model;

  const BuildItem({Key? key, required this.model}) : super(key: key);

  @override
  Widget build(BuildContext context) {
    return ColorFiltered(
      colorFilter: const ColorFilter.mode(Colors.transparent, BlendMode.saturation),
      child: Container(
        margin: EdgeInsets.only(left: 10.w, top: 10.w, right: 5.w),
        child: Stack(
          children: [
            Image.asset(
              model.type == 0
                  ? 'assets/images/coupon_bg.png'
                  : 'assets/images/coupon_bg_expired.png',
              fit: BoxFit.contain,
              width: double.infinity,
            ),
            // Image.asset(
            //     'assets/images/coupon_bg.png',
            //   fit: BoxFit.contain,
            //   width: double.infinity,
            // ),
            SizedBox(
              height: 105.w,
              child: Row(
                crossAxisAlignment: CrossAxisAlignment.center,
                children: [
                  SizedBox(
                    width: 120.w,
                    height: 100.w,
                    child: Column(
                      children: [
                        RichText(
                          overflow: TextOverflow.ellipsis, // 设置省略号
                          text: TextSpan(children: <TextSpan>[
                            TextSpan(
                                text: '￥',
                                style: TextStyle(
                                    fontSize: 15.w,
                                    fontWeight: Fonts.boldSemi,
                                    height: 1.5,
                                    color: model.type == 0
                                        ? Colors.white
                                        : Colours.cC8)),
                            TextSpan(
                                text: model.reducedPrice.toString(),
                                style: TextStyle(
                                    fontSize: 40.w,
                                    fontWeight: Fonts.boldSemi,
                                    height: 1.5,
                                    color: model.type == 0
                                        ? Colors.white
                                        : Colours.cC8)),
                          ]),
                        ),
                        Text(
                          '满${model.normPrice}可用',
                          style: TextStyle(
                              fontSize: 11.w, height: 1.5, color: model.type == 0
                              ? Colors.white
                              : Colours.cC8),
                        )
                      ],
                    ),
                    // color: Colors.cyan,
                  ),
                  Expanded(
                    child: Container(
                      margin: EdgeInsets.only(left: 11.w, right: 10.w),
                      child: Row(
                        mainAxisAlignment: MainAxisAlignment.spaceBetween,
                        children: [
                          SizedBox(
                            width: 139.w,
                            child: Column(
                              crossAxisAlignment: CrossAxisAlignment.start,
                              mainAxisAlignment: MainAxisAlignment.center,
                              children: [
                                Text(
                                  model.couponName ?? '',
                                  style: TextStyle(
                                      fontSize: 16.w,
                                      fontWeight: Fonts.medium,
                                      height: 1.5,
                                      color: model.type == 0
                                          ? Colours.c3
                                          : Colours.c9),
                                  maxLines: 1,
                                  overflow: TextOverflow.ellipsis,
                                ),
                                Gaps.vGaps5,
                                Text(
                                  '满${model.normPrice}减${model.reducedPrice}元',
                                  style: TextStyle(
                                      fontSize: 12.w,
                                      height: 1.5,
                                      color: Colours.c9),
                                  maxLines: 1,
                                  overflow: TextOverflow.ellipsis,
                                ),
                                Gaps.vGaps5,
                                Text(
                                  '有效至：${model.endTime}',
                                  style: TextStyle(
                                      fontSize: 12.w,
                                      height: 1.5,
                                      color: Colours.c9),
                                  maxLines: 1,
                                  overflow: TextOverflow.ellipsis,
                                ),
                              ],
                            ),
                          ),
                          model.type == 0
                              ? Stack(
                                  children: [
                                    //TODO 暂时隐藏  立即使用 按钮
                                    /* Positioned(
                              top: 40,
                                right: 0, // 右对齐的关键
                                child:  Align(
                                  alignment: Alignment.centerRight,
                                  child: GestureDetector(
                                    onTap: () {
                                      Console.log("点击了优惠券使用");
                                    },
                                    child:  Container(
                                      width: 65.w,
                                      height: 24.w,
                                      alignment: Alignment.center,
                                      decoration: BoxDecoration(
                                          borderRadius: BorderRadius.circular(15.w),
                                          color: Colors.white,
                                          border: Border.all(width: 1.w,color: AppTheme.primary)
                                      ),
                                      child: Text('立即使用',style: TextStyle(fontSize: 12.w,fontWeight: Fonts.medium,color: AppTheme.primary),),
                                    ),
                                  ),
                                ),),*/
                                    Align(
                                      alignment: Alignment.bottomRight,
                                      child: GestureDetector(
                                        onTap: () {
                                          Console.log("点击了优惠券使用规则");
                                          showDialog(
                                            context: context,
                                            builder: (BuildContext context) {
                                              return AlertDialog(
                                                shape: RoundedRectangleBorder(
                                                  borderRadius:
                                                      BorderRadius.circular(
                                                          8.0.w),
                                                ),
                                                contentPadding: EdgeInsets.zero,
                                                // 移除内容部分的内边距
                                                content: Wrap(
                                                  children: [
                                                    Stack(
                                                      children: [
                                                        Stack(
                                                          children: [
                                                            Positioned(
                                                              right: 10.w,
                                                              top: 10.w,
                                                              child:
                                                                  GestureDetector(
                                                                onTap: () {
                                                                  Navigator.of(
                                                                          context)
                                                                      .pop();
                                                                },
                                                                child: SizedBox(
                                                                  width: 20.w,
                                                                  height: 20.w,
                                                                  child: Image
                                                                      .asset(
                                                                          'assets/images/close.png'),
                                                                ),
                                                              ),
                                                            ),
                                                            Container(
                                                              padding: EdgeInsets
                                                                  .only(
                                                                      top: 29.5
                                                                          .w),
                                                              alignment:
                                                                  Alignment
                                                                      .topCenter,
                                                              child: Column(
                                                                crossAxisAlignment:
                                                                    CrossAxisAlignment
                                                                        .center,
                                                                children: [
                                                                  Text(
                                                                    '优惠券使用细则',
                                                                    style:
                                                                        TextStyle(
                                                                      fontSize:
                                                                          15.w,
                                                                      fontWeight:
                                                                          Fonts
                                                                              .medium,
                                                                      color:
                                                                          Colours
                                                                              .c3,
                                                                    ),
                                                                  ),
                                                                  SizedBox(
                                                                    height:
                                                                        14.w,
                                                                  ),
                                                                  Container(
                                                                    padding: EdgeInsets.only(
                                                                        left: 25.5
                                                                            .w,
                                                                        right: 18
                                                                            .w),
                                                                    child: Text(
                                                                      '1.在系统开启情况下购买书籍可使用优惠券，金额需满足优惠券的限制金额。 \n\n 2.每笔订单最多使用一张优惠券，不可叠加使用。',
                                                                      style:
                                                                          TextStyle(
                                                                        fontSize:
                                                                            11.w,
                                                                        color: Colours
                                                                            .c9,
                                                                      ),
                                                                    ),
                                                                  ),
                                                                  SizedBox(
                                                                    height:
                                                                        26.5.w,
                                                                  ),
                                                                ],
                                                              ),
                                                            ),
                                                          ],
                                                        ),
                                                      ],
                                                    ),
                                                  ],
                                                ),
                                                // 去除操作按钮区域的内边距
                                                actionsPadding: EdgeInsets.zero,
                                              );
                                            },
                                          );
                                        },
                                        child: Container(
                                          padding:
                                              EdgeInsets.only(bottom: 14.w),
                                          child: Text(
                                            '优惠券使用规则>',
                                            style: TextStyle(
                                                fontSize: 10.w,
                                                fontWeight: Fonts.medium,
                                                color: AppTheme.primary),
                                          ),
                                        ),
                                      ),
                                    ),
                                  ],
                                )
                              : Container(
                                  alignment: Alignment.center,
                                  padding: EdgeInsets.only(right: 5.5.w),
                                  child: SizedBox(
                                    height: 40.w,
                                    width: 64.w,
                                    child: Image.asset(
                                        "assets/images/coupon_expired.png"),
                                  ),
                                ),
                        ],
                      ),
                    ),
                  )
                ],
              ),
            )
          ],
        ),
      ),
    );
  }
}
