part of web;

class BuildSearchAll extends StatefulWidget {
  final void Function(SearchAllModel sModel)? onTap;
  final List<SearchAllModel> searchALlResults;

  const BuildSearchAll({
    Key? key,
    this.onTap,
    required this.searchALlResults
  }) : super(key: key);

  @override
  State<BuildSearchAll> createState() => _BuildSearchAllState();
}

class _BuildSearchAllState extends State<BuildSearchAll> {
  @override
  Widget build(BuildContext context) {
    return ListView.builder(
      itemBuilder: (BuildContext context, int index){
        SearchAllModel model = widget.searchALlResults[index];
        return GestureDetector(
          onTap: (){
            if(widget.onTap !=null){
              widget.onTap!(model);
            }
          },
          child: Container(
            color: Colors.white,
            child: Column(
              crossAxisAlignment: CrossAxisAlignment.start,
              children: [
                Container(
                  color: Colors.white,
                  margin: EdgeInsets.only(left: 15.w,top: 8.w),
                  // height: 110,
                  child: Column(
                    crossAxisAlignment: CrossAxisAlignment.start,
                    children: [
                      Text(model.chapterName??'',style: TextStyle(fontSize: 11.w,height: 2,color: Colours.c9,fontWeight: Fonts.medium),),
                      Gaps.vGaps5,
                      ColoredText(text: model.combinedContent??'', coloredSubstring: model.key??'', coloredTextStyle: TextStyle(fontSize: 13.w,height: 2,color: AppTheme.primary),),
                    ],
                  ),
                ),
                Gaps.vGaps10,
                Container(height: 0.5.w,color: Colours.cF2,)
              ],
            ),
          )
        );
      },
      itemCount: widget.searchALlResults.length,
    );
  }
}

class ColoredText extends StatelessWidget {
  final String text;
  final String coloredSubstring;
  final TextStyle coloredTextStyle;

  const ColoredText({super.key,
    required this.text,
    required this.coloredSubstring,
    required this.coloredTextStyle,
  });

  @override
  Widget build(BuildContext context) {
    return RichText(
      text: TextSpan(
        style: TextStyle(fontSize: 13.w,height: 2,color: Colours.c3),
        children: _buildTextSpans(),
      ),
    );
  }

  List<TextSpan> _buildTextSpans() {
    final List<TextSpan> spans = [];
    final int substringIndex = text.indexOf(coloredSubstring);

    if (substringIndex != -1) {
      spans.add(TextSpan(
        text: text.substring(0, substringIndex),
      ));
      spans.add(TextSpan(
        text: coloredSubstring,
        style: coloredTextStyle,
      ));
      spans.add(TextSpan(
        text: text.substring(substringIndex + coloredSubstring.length),
      ));
    } else {
      spans.add(TextSpan(text: text));
    }

    return spans;
  }
}



