part of user_order_coin_awaiting;

/// 紫荆币待支付
class UserOrderCoinAwaitingPage extends StatefulWidget {
  final String orderNum; // 订单编号
  const UserOrderCoinAwaitingPage({Key? key, required this.orderNum})
      : super(key: key);

  @override
  State<UserOrderCoinAwaitingPage> createState() =>
      _UserOrderCoinAwaitingState();
}

class _UserOrderCoinAwaitingState extends State<UserOrderCoinAwaitingPage> {
  late UserOrderCoinAwaitingController myController;

  @override
  void initState() {
    myController = Get.put(UserOrderCoinAwaitingController(context));
    myController.updateOrderNum(widget.orderNum);
    super.initState();
  }

  @override
  Widget build(BuildContext context) {
    return FutureBuilder(
      future: myController.getOrderInfo(),
      builder: (context, snapshot) {
        if (snapshot.connectionState == ConnectionState.waiting) {
          return Scaffold(
            appBar: AppBar(
              centerTitle: true,
              title: const Text('待支付'),
            ),
          );
        } else {
          return Scaffold(
            appBar: CustomAppBar(
              title: const Text('待支付'),
              actions: [],
            ),
            body: Column(
              children: [
                Container(
                  margin: EdgeInsets.symmetric(
                      horizontal: AppTheme.margin,
                      vertical: AppTheme.margin),
                  decoration: BoxDecoration(
                    borderRadius: BorderRadius.circular(8.w),
                    color: Colors.white,
                    boxShadow: [
                      BoxShadow(
                        color: Colours.cC7.withOpacity(0.5),
                        offset: Offset(3.w, 0),
                        blurRadius: 10.w,
                        spreadRadius: 0.w,
                      ),
                    ],
                  ),
                  child: ClipRRect(
                    borderRadius: BorderRadius.circular(8.w),
                    child: Column(
                      mainAxisAlignment: MainAxisAlignment.start,
                      mainAxisSize: MainAxisSize.min,
                      children: [
                        Padding(
                          padding: EdgeInsets.only(
                              left: 12.0.w,
                              top: 17.5.w,
                              bottom: 12.0.w),
                          child: Row(
                            mainAxisAlignment:
                            MainAxisAlignment.start,
                            crossAxisAlignment:
                            CrossAxisAlignment.start,
                            children: [
                              Image.asset(
                                'assets/images/coin.png',
                                // fit: BoxFit.cover, // 设置适应方式为充满
                                width: 42.0.w,
                                height: 42.0.w,
                              ),
                              Expanded(
                                child: Padding(
                                  padding:
                                  EdgeInsets.only(right: 16.5.w),
                                  child: Column(
                                    mainAxisAlignment:
                                    MainAxisAlignment
                                        .spaceBetween,
                                    crossAxisAlignment:
                                    CrossAxisAlignment.end,
                                    // 下面的Text靠左
                                    children: [
                                      Text(
                                        '充值${myController.model.bean}紫荆币',
                                        style: TextStyle(
                                          color: Colours.c3,
                                          fontWeight: Fonts.bold,
                                          fontSize: 13.w,
                                        ),
                                        maxLines: 2,
                                        overflow: TextOverflow
                                            .ellipsis, // 超过部分显示省略号
                                      ),
                                      SizedBox(height: 9.w),
                                      Text(
                                        "需付款 ¥${myController.model.finalTotalPrice}",
                                        style: TextStyle(
                                          color: Colours.cAB1941,
                                          fontWeight: Fonts.bold,
                                          fontSize: 14.w,
                                        ),
                                      ),
                                    ],
                                  ),
                                ),
                              ),
                            ],
                          ),
                        ),
                        Container(
                          color: Colours.cLine,
                          margin: EdgeInsets.only(
                              left: 10.w, right: 10.w, bottom: 12.w),
                          height: 1.w,
                        ),
                        Container(
                          padding: EdgeInsets.only(
                              left: 11.5.w,
                              bottom: 8.w,
                              right: 23.5.w),
                          child: Column(
                            mainAxisAlignment:
                            MainAxisAlignment.spaceEvenly,
                            children: myController.orderAwaitings
                                .map((model) {
                              return Padding(
                                padding: EdgeInsets.only(top: 12.w),
                                child: Row(
                                  mainAxisAlignment:
                                  MainAxisAlignment.spaceBetween,
                                  children: [
                                    Text(
                                      model.name,
                                      style: TextStyle(
                                          fontSize: 13.w,
                                          height: 1.6.w,
                                          color: Colours.c9),
                                    ),
                                    Text(
                                      model.value.toString(),
                                      style: TextStyle(
                                          fontSize: 13.w,
                                          height: 1.6.w,
                                          color: Colours.c3),
                                    ),
                                  ],
                                ),
                              );
                            }).toList(),
                          ),
                        ),
                        SizedBox(
                          height: 13.5.w,
                        ),
                      ],
                    ),
                  ),
                ),
                SizedBox(
                  height: 11.5.w,
                ),
                GestureDetector(
                  onTap: (){
                    myController.payOrder();
                  },
                  child: Container(
                    margin: EdgeInsets.symmetric(horizontal: 15.w),
                    height: 40.w,
                    decoration: BoxDecoration(
                        color: AppTheme.primary,
                        borderRadius: BorderRadius.circular(180.w),
                        border: Border.all(
                            color: Colours.cC31F4C, width: 0.5.w)),
                    child: Center(
                      child: Text(
                        '立即支付 ¥${myController.model.finalTotalPrice}',
                        style: TextStyle(
                            fontWeight: Fonts.medium,
                            fontSize: 14.w,
                            color: Colours.cFF),
                      ),
                    ),
                  ),
                ),
                SizedBox(
                  height: 11.5.w,
                ),
                GestureDetector(
                  onTap: () {
                    showDialog(
                      context: context,
                      builder: (BuildContext context) {
                        return AlertDialog(
                          shape: RoundedRectangleBorder(
                            borderRadius:
                            BorderRadius.circular(8.0.w),
                          ),
                          contentPadding: EdgeInsets.zero,
                          // 移除内容部分的内边距
                          content: Wrap(
                            children: [
                              Container(
                                margin: EdgeInsets.only(
                                    top: 44.w,
                                    bottom: 29.w), // 调整上下间距
                                child: Center(
                                  child: Text(
                                    '确定取消订单吗',
                                    style: TextStyle(
                                      fontSize: 15.w,
                                      fontWeight: Fonts.medium,
                                      color: Colours.c3,
                                    ),
                                  ),
                                ),
                              ),
                              Container(
                                height: 1.w, // 设置分割线的高度
                                width: double.infinity, // 设置分割线的宽度
                                color: Colours.cLine, // 设置分割线的颜色
                              ),
                            ],
                          ),
                          // 去除操作按钮区域的内边距
                          actionsPadding: EdgeInsets.zero,
                          actions: <Widget>[
                            Row(
                              mainAxisAlignment:
                              MainAxisAlignment.spaceEvenly,
                              // 或者使用MainAxisAlignment.spaceEvenly
                              children: [
                                GestureDetector(
                                  onTap: () =>
                                      Navigator.of(context).pop(),
                                  child:Container(
                                    width: 105.w,
                                    color: Colours.cFF,
                                    alignment: Alignment.center,
                                    child: const Text(
                                      '取消',
                                      style: TextStyle(
                                        fontSize: 14,
                                        fontWeight: Fonts.medium,
                                        color: Colours.c6,
                                      ),
                                    ),
                                  ),
                                ),
                                Container(
                                  height: 39.5.w, // 设置分割线的高度
                                  width: 1, // 设置分割线的宽度
                                  color: Colours.cLine, // 设置分割线的颜色
                                ),
                                GestureDetector(
                                  onTap: () async {
                                    Future<bool> result = myController.cancelPay();
                                    if(await result){
                                      Navigator.of(context).pop();
                                      context.pop(true);
                                    }
                                  },
                                  child:Container(
                                    width: 105.w,
                                    color: Colours.cFF,
                                    alignment: Alignment.center,
                                    child: const  Text(
                                      '确定',
                                      style: TextStyle(
                                        fontSize: 14,
                                        fontWeight: Fonts.boldSemi,
                                        color: Colours.cAB1941,
                                      ),
                                    ),
                                  ),
                                ),
                              ],
                            ),
                          ],
                        );
                      },
                    );
                  },
                  child: Container(
                    width: 105.w,
                    color: Colours.cFF,
                    alignment: Alignment.center,
                    child: const  Text(
                      '取消订单',
                      style: TextStyle(
                        fontWeight: Fonts.medium,
                        fontSize: 15,
                        color: Colours.c9,
                      ),
                    ),
                  ),
                ),
              ],
            ),
          );
        }
      },
    );
  }
}
