part of web;

class ReadCategoryPage extends StatefulWidget {
  final ReadController controller;
  final void Function()? onTap;
  // 点击 搜索全文 中的列表事件
  final void Function(SearchAllModel sModel)? onTapSearchItem;
  final Function(ChapterModel chapterModel) onTapChapter;
  const ReadCategoryPage({
    Key? key,
    required this.controller,
    required this.onTap,
    required this.onTapChapter,
    this.onTapSearchItem
  }) : super(key: key);

  @override
  State<ReadCategoryPage> createState() => _ReadCategoryPageState();
}

class _ReadCategoryPageState extends State<ReadCategoryPage> {

  late TextEditingController searchController = TextEditingController();

  @override
  Widget build(BuildContext context) {
    return Scaffold(
      resizeToAvoidBottomInset: false,
      body: Column(
        crossAxisAlignment: CrossAxisAlignment.end,
        children: [
          GestureDetector(
            onTap: (){
              widget.onTap!();
            },
            child: Container(
                // color: Colors.red,
                padding: EdgeInsets.only(left: 15.w,right: 15.w,top: 15.w,bottom: 15.w),
                child: Image.asset('assets/images/close.png')
            ),
          ),
          Row(
            children: [
              Expanded(
                child: Container(
                  margin: EdgeInsets.only(left: 15.w,right: 15.w,),
                  decoration: BoxDecoration(
                    color: const Color(0xFFF9F9F9),
                    borderRadius: BorderRadius.circular(17.5.w),
                    boxShadow: [
                      BoxShadow(
                        color: const Color(0xFFC7C7C7).withOpacity(0.5),
                        offset: Offset(3.w, 0),
                        blurRadius: 10.w,
                        spreadRadius: 0.w,
                      ),
                    ],
                  ),
                  child: ClipRRect(
                    borderRadius: BorderRadius.circular(17.5.w),
                    child: CustomInputSearch(
                      controller: widget.controller.searchInput,
                      readOnly: false,
                      hintText: '搜索全文',
                      onTap: () {
                        // context.pushNamed(Routes.msgs);
                      },
                      onEditingComplete: () {
                        widget.controller.setShowSearch(true);
                        widget.controller.onRefreshSearch();
                        Tools.unfocus();
                      },
                    ),
                  ),
                ),
              ),
              widget.controller.showSearch?GestureDetector(
                  onTap: () {
                    widget.controller.setShowSearch(false);
                    Tools.unfocus();
                  },
                  child:  Container(
                    margin: EdgeInsets.only(right: 15.w),
                    child: Text('取消'),
                  )
              ):const SizedBox(),
            ],
          ),
          widget.controller.showSearch? Expanded(
              child: BuildSearchAll(
                onTap: (SearchAllModel sModel){
                  if (widget.onTapSearchItem !=null) {
                    widget.onTapSearchItem!(sModel);
                  }
                },
                searchALlResults: widget.controller.searchALlResults
          ,)):
          widget.controller.showSearch?const SizedBox():BuildBook(bookDetailModel: widget.controller.bookDetailModel,),
          widget.controller.showSearch?const SizedBox():Expanded(
            child: ListView.builder(
              itemBuilder:(BuildContext context, int index){
                return BuildItem(model: widget.controller.chapters[index],onTapChapter:(ChapterModel chapterModel){
                  widget.onTapChapter(chapterModel);
                  widget.onTap;
                },);
              },
              itemCount: widget.controller.chapters.length,
            ),
          ),
        ],
      ),
    );
  }
}
