part of course;

class BuildBanner extends StatelessWidget {
  final List <AdModel>items;
  const BuildBanner({
    Key? key,
    this.items = const [],
  }) : super(key:key);

  @override
  Widget build(BuildContext context) {
    Random random = Random();
    return CarouselSlider(
      options: CarouselOptions(
        // 自动滚动
        autoPlay: items.length > 1,
        // 是否无限滚动
        enableInfiniteScroll: items.length > 1,
        // 居中的是否放大
        enlargeCenterPage: false,
        // 宽高比例
        aspectRatio: 19 / 9,
        // 是否占满满视图
        viewportFraction: 1,
      ),
      items: items.map((item) {
        return SafeArea(
          minimum: const EdgeInsets.symmetric(horizontal: 0).copyWith(bottom: 0),
          child: Container(
            width: double.infinity,
            decoration: BoxDecoration(
              borderRadius: BorderRadius.circular(8.w),
              // color: Color.fromRGBO(
              //   random.nextInt(256), // Red
              //   random.nextInt(256), // Green
              //   random.nextInt(256), // Blue
              //   1.0, // Alpha (opacity)
              // ),

            ),
            //CustomImage.network(item.pic??'',)
            child: ClipRRect(
              borderRadius: BorderRadius.circular(8.w),
                child: CustomImage.network(url: item.pic??'')
            ),
            // child: CustomImage.asset(
            //   url: 'assets/images/banner.png',
            //   width: 130.w,
            //   fit: BoxFit.contain,
            // ),
          ),
        );
      }).toList(),
    );
  }
}
