part of user_order_refunded;

/// 订单已退款界面
class UserOrderRefundedPage extends StatefulWidget {
  final String orderNum; // 订单编号
  const UserOrderRefundedPage({Key? key , required this.orderNum}) : super(key: key);

  @override
  State<UserOrderRefundedPage> createState() => _UserOrderRefundedState();
}

class _UserOrderRefundedState extends State<UserOrderRefundedPage> {
  @override
  Widget build(BuildContext context) {
    return WillPopScope(
      onWillPop: () async {
        context.pop(true);
        return false;
      },
      child: GetBuilder<UserOrderCRefundedController>(
          init: UserOrderCRefundedController(widget.orderNum),
          builder: (controller) => Scaffold(
              appBar: CustomAppBar(
                title: const Text('已退款'),
                actions: [],
              ),
              body:Column(children: [
                Container(
                  width: double.infinity,
                  margin: EdgeInsets.symmetric(
                      horizontal: AppTheme.margin, vertical: AppTheme.margin),
                  decoration: BoxDecoration(
                    borderRadius: BorderRadius.circular(8.w),
                    color: Colors.white,
                    boxShadow: [
                      BoxShadow(
                        color: Colours.cC7.withOpacity(0.5),
                        offset: Offset(3.w, 0),
                        blurRadius: 10.w,
                        spreadRadius: 0.w,
                      ),
                    ],
                  ),
                  child: ClipRRect(
                    borderRadius: BorderRadius.circular(8.w),
                    child: Column(
                      mainAxisAlignment: MainAxisAlignment.start,
                      mainAxisSize: MainAxisSize.min,
                      children: [
                        Padding(
                          padding: EdgeInsets.only(
                              left: 12.0.w, top: 12.0.w, bottom: 12.0.w),
                          child: Row(
                            mainAxisAlignment: MainAxisAlignment.start,
                            crossAxisAlignment: CrossAxisAlignment.start,
                            children: [
                              Image.network(
                                controller.model?.bookList==null?'http://zxts-book-file.zijingebook.com/2024-01/29/b91194564969b9151fa382807977282acdffa22d.jpg':
                                controller.model.bookList![0].img??'',
                                // 用实际图片链接替换
                                fit: BoxFit.cover, // 设置适应方式为充满
                                width: 72.0.w,
                                height: 86.0.w,
                              ),
                              Expanded(
                                child: Padding(
                                  padding: EdgeInsets.only(
                                      left: 12.0.w, top: 5.5.w, right: 23.5.w),
                                  child: Column(
                                    mainAxisAlignment:
                                    MainAxisAlignment.spaceBetween,
                                    crossAxisAlignment:
                                    CrossAxisAlignment.start, // 下面的Text靠左
                                    children: [
                                      Container(
                                        height: 62.5.w,
                                        child:  Text(
                                          controller.model?.bookList?[0].introduction??'',
                                          style: TextStyle(
                                            color: Colours.c3,
                                            fontWeight: Fonts.bold,
                                            fontSize: 13.w,
                                          ),
                                          maxLines: 2,
                                          overflow:
                                          TextOverflow.ellipsis, // 超过部分显示省略号
                                        ),
                                      ),
                                      Container(
                                        alignment: Alignment.topRight,
                                        child:  Text(
                                          "¥${controller.model.totalPrice}",
                                          style: TextStyle(
                                            color: Colours.cAB1941,
                                            fontWeight: Fonts.medium,
                                            fontSize: 14.w,
                                          ),
                                        ),
                                      )

                                    ],
                                  ),
                                ),
                              ),
                            ],
                          ),
                        ),
                        Container(
                          color: Colours.cLine,
                          margin: EdgeInsets.only(
                              left: 10.w, right: 10.w, bottom: 12.w),
                          height: 1.w,
                        ),
                        Container(
                          padding: EdgeInsets.only(
                              left: 11.5.w, bottom: 8.w, right: 10.w),
                          child: Column(
                            mainAxisAlignment: MainAxisAlignment.spaceEvenly,
                            children: controller.orderCompleteds.map((model) {
                              return Padding(
                                padding: EdgeInsets.only(top: 12.w),
                                child: Row(
                                  mainAxisAlignment:
                                  MainAxisAlignment.spaceBetween,
                                  children: [
                                    Text(
                                      model.name,
                                      style: TextStyle(
                                          fontSize: 13.w,
                                          height: 1.6.w,
                                          color: Colours.c9),
                                    ),
                                    controller.orderCompleteds.indexOf(model) == 0 ?
                                    GestureDetector(
                                        onTap: () {
                                          showModalBottomSheet(
                                            context: context,
                                            shape: RoundedRectangleBorder(
                                              borderRadius: BorderRadius.vertical(top: Radius.circular(8.w)),
                                            ),
                                            builder: (BuildContext context) {
                                              return RefundedDetailsPage(totalPrice: controller.model.totalPrice.toString(),
                                                couponPrice: controller.model.couponPrice.toString(),
                                                integralPrice: controller.model.integralPrice.toString(),);
                                            },
                                          ).then((value) {
                                            print('点击了应付款后面');
                                          });

                                        },
                                        child: Row(
                                          mainAxisAlignment:
                                          MainAxisAlignment.spaceBetween,
                                          children: [
                                            Text(
                                              '共减 ¥ ${model.other.toString()}',
                                              style: TextStyle(
                                                fontSize: 13.w,
                                                height: 1.6,
                                                color: AppTheme.primary,
                                              ),
                                            ),
                                            SizedBox(
                                              width: 8.w,
                                            ),
                                            Text(
                                              '合计${model.value.toString()}',
                                              style: TextStyle(
                                                fontSize: 13.w,
                                                height: 1.6,
                                                color: Colours.c9,
                                              ),
                                            ),
                                            Gaps.hGaps8,
                                            Padding(
                                              padding:
                                              EdgeInsets.only(top: 4.w),
                                              child: Image.asset(
                                                'assets/images/right_arrow.png',
                                              ),
                                            ),
                                          ],
                                        ))
                                        : Padding(
                                      padding:
                                      EdgeInsets.only(right: 12.5.w),
                                      child: Text(
                                        model.value.toString(),
                                        style: TextStyle(
                                            fontSize: 13.w,
                                            height: 1.6.w,
                                            color: Colours.c9),
                                      ),
                                    ),
                                  ],
                                ),
                              );
                            }).toList(),
                          ),
                        ),
                        SizedBox(
                          height: 14.5.w,
                        ),
                      ],
                    ),
                  ),
                ),
                SizedBox(height: 4.w,),
                Container(
                  width: double.infinity,
                  margin: EdgeInsets.symmetric(
                      horizontal: AppTheme.margin),
                  decoration: BoxDecoration(
                    borderRadius: BorderRadius.circular(8.w),
                    color: Colors.white,
                    boxShadow: [
                      BoxShadow(
                        color: Colours.cC7.withOpacity(0.5),
                        offset: Offset(3.w, 0),
                        blurRadius: 10.w,
                        spreadRadius: 0.w,
                      ),
                    ],
                  ),
                  child: ClipRRect(
                    borderRadius: BorderRadius.circular(8.w),
                    child: Container(margin: EdgeInsets.only(top:24.w,left:11.5.w,right: 23.5.w,bottom: 24.w),
                    child: Column(
                      mainAxisAlignment: MainAxisAlignment.start,
                      crossAxisAlignment: CrossAxisAlignment.start,
                      children: [
                        Text('退款原因',style: TextStyle(fontSize: 13.w,color: Colours.c9),),
                      SizedBox(height: 8.w,),
                        Text(controller.model.refundReason.toString(),style: TextStyle(fontSize: 13.w,color: Colours.c3),)
                      ],
                    ),
                    ),
                  ),
                )
              ],),
          )),
    );
  }
}
